import React, { Component } from 'react';
import PropTypes from 'prop-types';
import { Icon,Row,Col } from 'amos-antd';
import ObilityOptionsFilter from './../../common/filterOptions/obilityOptionsFilter';
import ProtocolOptionsFilter from './../../common/filterOptions/protocolOptionsFilter';
import CommunityOptionsFilter from './../../common/filterOptions/communityOptionsFilter';
import IndustryOptionsFilter from './../../common/filterOptions/industryOptionsFilter';

/**
 * 筛选按钮
 *
 * @class FilterBtn
 * @extends {Component}
 */
class FilterBtn extends Component {
  constructor(props) {
    super(props);
    this.state = {
      obilitySelectedOption: [],
      protocolSelectedOption: [],
      communitySelectedOption: [],
      industrySelectedOption:[]
    };
  }

  obilitySelectFunc = (values) => {
    this.setState({ obilitySelectedOption: values });
    this.props.obilityValueChange(values);
  }

  protocolSelectFunc = (values) => {
    this.setState({ protocolSelectedOption: values });
    this.props.protocolValueChange(values);
  }

  communitySelectFunc = (values) => {
    this.setState({ communitySelectedOption: values });
    this.props.communityValueChange(values);
  }


  industrySelectFunc = (values) => {
    this.setState({ industrySelectedOption: values });
    this.props.industryValueChange(values);
  }

  //单个删除筛选条件
  delBtn = (value) => {
    let { obilitySelectedOption,protocolSelectedOption,communitySelectedOption,industrySelectedOption } = this.state;
    let obilityfilterList = [];
    obilitySelectedOption.map(option=>{
      if (option.label === value) {
        option.selected = false;
        option.style = 'all-filter-btn';
      }
      if (option.selected) {
        obilityfilterList.push(option);
      }
    });
    if (obilityfilterList.length === 0) {
      this.refs.protocolChild.disableAllSelected();
    }
    this.setState({ obilitySelectedOption });
    this.props.obilityValueChange(obilityfilterList);

    let protocolfilterList = [];
    protocolSelectedOption.map(option=>{
      if (option.label === value) {
        option.selected = false;
        option.style = 'all-filter-btn';
      }
      if (option.selected) {
        //selectedNum += 1;
        protocolfilterList.push(option);
      }
    });
    if (protocolfilterList.length === 0) {
      this.refs.obilityChild.disableAllSelected();
    }
    this.setState({ protocolSelectedOption });
    this.props.protocolValueChange(protocolfilterList);

    let communityfilterList = [];
    communitySelectedOption.map(option=>{
      if (option.label === value) {
        option.selected = false;
        option.style = 'all-filter-btn';
      }
      if (option.selected) {
        //selectedNum += 1;
        communityfilterList.push(option);
      }
    });
    if (communityfilterList.length === 0) {
      this.refs.communityChild.disableAllSelected();
    }
    this.setState({ communitySelectedOption });
    this.props.communityValueChange(communityfilterList);

    let industryfilterList = [];
    industrySelectedOption.map(option=>{
      if (option.label === value) {
        option.selected = false;
        option.style = 'all-filter-btn';
      }
      if (option.selected) {
        //selectedNum += 1;
        industryfilterList.push(option);
      }
    });
    if (industryfilterList.length === 0) {
      this.refs.industryChild.disableAllSelected();
    }
    this.setState({ industrySelectedOption });
    this.props.industryValueChange(industryfilterList);
  }

  //加载已选择的条件
  selectOptions = () => {
    let res = [];
    let { obilitySelectedOption,protocolSelectedOption,communitySelectedOption,industrySelectedOption } = this.state;
    obilitySelectedOption.map(option=>{
      if (option.selected) {
        res.push(
          <div id={'obility' + option.value} onClick={() => this.delBtn(option.label)} className='select-filter-btn'>
            {option.label}<Icon type='close' />
          </div>);
      }
    });
    protocolSelectedOption.map(option=>{
      if (option.selected) {
        res.push(
          <div id={'protocol' + option.value} onClick={() => this.delBtn(option.label)} className='select-filter-btn'>
            {option.label}<Icon type='close' />
          </div>);
      }
    });
    communitySelectedOption.map(option=>{
      if (option.selected) {
        res.push(
          <div id={'community' + option.value} onClick={() => this.delBtn(option.label)} className='select-filter-btn'>
            {option.label}<Icon type='close' />
          </div>);
      }
    });

    industrySelectedOption.map(option=>{
      if (option.selected) {
        res.push(
          <div key={`industry${option.value}`} id={'industry' + option.value} onClick={() => this.delBtn(option.label)} className='select-filter-btn'>
            {option.label}<Icon type='close' />
          </div>);
      }
    });
    return res;
  }

  render() {
    return (
      <div>
        <Row>
          <Col span={8}>
            <span>筛选条件：</span>
          </Col>
          <Col span={16}>
            {this.selectOptions()}
          </Col>
        </Row>
        <Row>
          <Col span={8}>
            <span>分类：</span>
          </Col>
          <Col span={16}>
            <ObilityOptionsFilter obilitySelectFunc={this.obilitySelectFunc} ref='obilityChild' {...this.props} />
          </Col>
        </Row>
        <Row>
          <Col span={8}>
            <span>协议：</span>
          </Col>
          <Col span={16}>
            <ProtocolOptionsFilter protocolSelectFunc={this.protocolSelectFunc} ref='protocolChild' {...this.props} />
          </Col>
        </Row>
        <Row>
          <Col span={8}>
            <span>设备接口：</span>
          </Col>
          <Col span={16}>
            <CommunityOptionsFilter communitySelectFunc={this.communitySelectFunc} ref='communityChild' {...this.props} />
          </Col>
        </Row>
        <Row>
          <Col span={8}>
            <span>所属行业：</span>
          </Col>
          <Col span={16}>
            <IndustryOptionsFilter industrySelectFunc={this.industrySelectFunc} ref='industryChild' {...this.props} />
          </Col>
        </Row>
      </div>
    );
  }
}

FilterBtn.propTypes = {
  obilityValueChange: PropTypes.func,
  protocolValueChange: PropTypes.func,
  communityValueChange: PropTypes.func,
  communityOptions: PropTypes.array,
  equiptemplateIndustryOptions:PropTypes.array,
  flag: PropTypes.string
};

export default FilterBtn;
