import { parseText } from 'amos-tool';

// 昆山宁华
const _nodelList = [
  { key: 'heptafluoropropane', text: '七氟丙烷', type: 'heptafluoropropane' },
  { key: 'fire-hydrant', text: '消防栓', type: 'fireHydrant' },
  { key: 'hands-alarm', text: '手动火灾报警', type: 'handsAlarm' },
  { key: 'fire-alarm', text: '火灾声光报警', type: 'fireAlarm' },
  { key: 'fire-cabinet', text: '消防柜', type: 'fireCabinet' },
  { key: 'fire-alarm-controller', text: '火灾报警控制器', type: 'fireAlarmController' },
  { key: 'fire-detection', text: '火探', type: 'fireDetection' },
  { key: 'fire-proof-door', text: '防火门', type: 'fireProofDoor' },
  { key: 'heptafluoropropane-ig541', text: '七氟丙烷 ig541', type: 'heptafluoropropaneIg541' }
];

export const DB_CLICK_ELE = 'DB_CLICK_ELE';
export const nodeIconPath = '/src/assets/iot/node/{iconName}.png';

const completeData = (datas) => {
  return datas.map(d => {
    d.icon = parseText(nodeIconPath, { iconName: d.key });
    return d;
  });
};

export const nodelList = completeData(_nodelList);

export const completeItemTypeIcon = (type) => {
  return parseText(nodeIconPath, { iconName: type });
};

/**
 * 删除元素主题
 */
export const TOPO_ELE_DEL_TOPIC = {
  eleDel: 'TOPO_ELE_DEL',
  action: 'TOPO_ELE_DEL.ACTION',
  condition: 'TOPO_ELE_DEL.CONDITION',
  common: 'TOPO_ELE_DEL.COMMON',
  sink: 'TOPO_ELE_DEL.SINK',
  object: 'TOPO_ELE_DEL.OBJECT',
  status: 'TOPO_ELE_DEL.STATUS',
  custom: 'TOPO_ELE_DEL.CUSTOM',
  actionlist: 'TOPO_ELE_DEL.ACTIONLIST',
  trigger: 'TOPO_ELE_DEL.TRIGGER',
  flowAction: 'TOPO_ELE_DEL.FLOWACTION',
  note: 'TOPO_ELE_DEL.NOTE'
};

/**
 * 显示详情主题
 */
export const TOPO_SHOW_PROPERTY_TOPIC = {
  eleShow: 'TOPO_SHOW_PROPERTY_TOPIC',
  action: 'TOPO_SHOW_PROPERTY_TOPIC.ACTION',
  condition: 'TOPO_SHOW_PROPERTY_TOPIC.CONDITION',
  common: 'TOPO_SHOW_PROPERTY_TOPIC.COMMON',
  sink: 'TOPO_SHOW_PROPERTY_TOPIC.SINK',
  object: 'TOPO_SHOW_PROPERTY_TOPIC.OBJECT',
  status: 'TOPO_SHOW_PROPERTY_TOPIC.STATUS',
  custom: 'TOPO_SHOW_PROPERTY_TOPIC.CUSTOM',
  actionlist: 'TOPO_SHOW_PROPERTY_TOPIC.ACTIONLIST',
  trigger: 'TOPO_SHOW_PROPERTY_TOPIC.TRIGGER',
  flowAction: 'TOPO_SHOW_PROPERTY_TOPIC.FLOWACTION',
  note: 'TOPO_SHOW_PROPERTY_TOPIC.NOTE'
};

/**
 * 点击选中
 */
export const TOPO_ENABLE_CLICK_TOPIC = {
  eleShow: 'TOPO_ENABLE_CLICK_TOPIC',
  action: 'TOPO_ENABLE_CLICK_TOPIC.ACTION',
  condition: 'TOPO_ENABLE_CLICK_TOPIC.CONDITION',
  common: 'TOPO_ENABLE_CLICK_TOPIC.COMMON',
  sink: 'TOPO_ENABLE_CLICK_TOPIC.SINK',
  object: 'TOPO_ENABLE_CLICK_TOPIC.OBJECT',
  status: 'TOPO_ENABLE_CLICK_TOPIC.STATUS',
  custom: 'TOPO_ENABLE_CLICK_TOPIC.CUSTOM',
  actionlist: 'TOPO_ENABLE_CLICK_TOPIC.ACTIONLIST',
  trigger: 'TOPO_ENABLE_CLICK_TOPIC.TRIGGER',
  flowAction: 'TOPO_ENABLE_CLICK_TOPIC.FLOWACTION',
  note: 'TOPO_ENABLE_CLICK_TOPIC.NOTE'
};

/**
 * 切换配置项
 */
export const TOPO_SWITCH_CONFIG_TOPIC = {
  switchConfig: 'TOPO_SWITCH_CONFIG_TOPIC',
  action: 'TOPO_SWITCH_CONFIG_TOPIC.ACTION',
  condition: 'TOPO_SWITCH_CONFIG_TOPIC.CONDITION',
  common: 'TOPO_SWITCH_CONFIG_TOPIC.COMMON',
  sink: 'TOPO_SWITCH_CONFIG_TOPIC.SINK',
  object: 'TOPO_SWITCH_CONFIG_TOPIC.OBJECT',
  status: 'TOPO_SWITCH_CONFIG_TOPIC.STATUS',
  custom: 'TOPO_SWITCH_CONFIG_TOPIC.CUSTOM',
  actionlist: 'TOPO_SWITCH_CONFIG_TOPIC.ACTIONLIST',
  trigger: 'TOPO_SWITCH_CONFIG_TOPIC.TRIGGER',
  flowAction: 'TOPO_SWITCH_CONFIG_TOPIC.FLOWACTION',
  note: 'TOPO_SWITCH_CONFIG_TOPIC.NOTE'
};


