import React, { Component } from 'react';
import PropTypes from 'prop-types';
import { Card, Modal } from 'amos-antd';
import AddCard from './addCard';
import SubviewItem from './subviewItem';
import CommonDeviceCell from './../../common/cell/CommonDeviceCell';
import './../topo.scss';

/**
 * topo内容管理
 *
 * @class TopoMangent
 * @extends {Component}
 */
class TopoMangent extends Component {

  render() {
    let { subviewList } = this.props;
    return (
      <div className='topo-new-content'>
        <CommonDeviceCell subviewInfo={{ name: '新建视图' }} type={1} {...this.props} />
        {
          subviewList.map(svObj => (
            <CommonDeviceCell key={svObj.id} subviewInfo={svObj} type={2} {...this.props} />
          ))
        }
      </div>
    );
  }
}
TopoMangent.propTypes = {
  subviewList: PropTypes.any
};
export default TopoMangent;
