import React, { Component } from 'react';
import PropTypes from 'prop-types';
import Icon from 'amos-icon';
import { Popover } from 'amos-antd';
import classnames from 'classnames';

const footerSpans = [
  { key: 'f1', style: { backgroundColor: '#00bbd3' } },
  { key: 'f2', style: { backgroundColor: '#8ac249' } },
  { key: 'f3', style: { backgroundColor: '#fc0' } },
  { key: 'f4', style: { backgroundColor: '#e6564a' } }
];

/**
 *
 *
 * @class BackgroundItem
 * @extends {Component}
 */
class BackgroundItem extends Component {

  render() {
    const { bkImg, name, bgColor = 'transparent', skinUse, onThemeChange,imgName } = this.props;
    const cls = classnames('bk-item', {
      'normal': !skinUse,
      'used': skinUse
    });
    return (
      <div className={cls} onClick={(e) => onThemeChange(e,bkImg,imgName)}>
        <img src={bkImg} alt="" />
        <div className="bk-name" style={{ backgroundColor: bgColor }}>
          <Popover placement="top" content={name} >
            <label>{name}</label>
          </Popover>
        </div>
        <div className="bk-footer">
          {
            footerSpans.map(footer => <span key={footer.key} style={footer.style} />)
          }
        </div>
        <div className="bk-check" style={{ backgroundColor: bgColor }}>选用皮肤</div>
        <div className="bk-use" style={{ display: skinUse ? 'block' : 'none' }}>
          <Icon icon="xuanzhong" />使用中
        </div>
      </div>
    );
  }
}


BackgroundItem.propTypes = {
  bkImg: PropTypes.string,
  name: PropTypes.string,
  bgColor: PropTypes.string,
  skinUse: PropTypes.bool,
  onThemeChange: PropTypes.func,
  imgName: PropTypes.string
};

BackgroundItem.defaultProps = {
  skinUse: false
};

export default BackgroundItem;
