import React, { Component } from 'react';
import PropTypes from 'prop-types';
import { PieCharts } from 'amos-core';
import { browserHistory } from 'amos-react-router';
import { PubSub } from 'ray-eventpool';
import {
  option
} from './chartData/EquipProtocolData';
import { countProtocolInfoAction } from './../../../../services/protocoService';
import { STATICTICS_JUMP_TOPIC } from './modelConf/nodeConf';

const num = 2 * 10;//平均值乘以10
/**
 * 设备协议统计
 *
 * @class EquipProtocol
 * @extends {Component}
 */
class EquipProtocol extends Component {
  constructor(props) {
    super(props);
    this.state = {
      count: 0,
      pubCount: 0,
      priCount: 0
    };
  }

  componentDidMount(){
    countProtocolInfoAction().then(data => {
      this.setState({
        count: data.count,
        pubCount: data.pubCount,
        priCount: data.priCount
      });
    });
  }

  eConsole = (param) => {
    let dataIndex = param.dataIndex;
    this.jumpTrigger();
    if (dataIndex === 0){
      browserHistory.push('/main/monitor/deviceCustom/deviceProtocol');
    } else if (dataIndex === 2) {
      browserHistory.push(`/main/monitor/deviceCustom/deviceProtocol?activeKey=2`);
    }
  }

  jumpTrigger = () => {
    PubSub.publish(STATICTICS_JUMP_TOPIC.trigger, {
      childkey: '11',
      parentKey: '9'
    });
  }

  render() {
    let { count,pubCount,priCount } = this.state;
    let array = [];
    let param = {
      type: 'click',
      handler: this.eConsole
    };
    array.push(param);
    let tempOption = option;
    tempOption.series[0].data[0].value = pubCount;
    tempOption.series[0].data[1].value = count / num;
    tempOption.series[0].data[2].value = priCount;
    tempOption.series[0].data[3].value = count / num;
    return (
      <div className="overview-item-chart">
        <div className="overview-prototypeequip-chart">
          <PieCharts
            pieOps={option}
            chartStyle={{ width: '100%', height: '82px' }}
            eventpool={array}
          />
        </div>
        <div className="overview-prototypeequip-item title">
          <p className="value">{count}</p>
          <p className="">总数</p>
        </div>
        <div className="overview-prototypeequip-item first">
          <p className="value" onClick={(e) => this.eConsole({ dataIndex: 0 },e)}>{pubCount}</p>
          <p className=""><span />公开通信协议</p>
        </div>
        <div className="overview-prototypeequip-item second">
          <p className="value" onClick={(e) => this.eConsole({ dataIndex: 2 },e)}>{priCount}</p>
          <p className=""><span />私有通信协议</p>
        </div>
      </div>
    );
  }
}

export default EquipProtocol;
