/**
 * @title 按钮类型
 */
import { Button } from 'amos-framework';

const ButtonType = () => {
  return (
    <div>
      <Button>默认</Button>
      <Button type="minor">次要</Button>
    </div>
  );
};

/**
 * @title 按钮尺寸
 */
import { Button } from 'amos-framework';

const ButtonSize = () => {
  return (
    <div>
      <Button size="lg">大尺寸</Button>
      <Button>默认</Button>
      <Button size="sm">小尺寸</Button>
    </div>
  );
};

/**
 * @title 图标按钮
 * @desc 如果需要自定义图标位置，结合使用 Icon 组件
 */
import { Button } from 'amos-framework';

const ButtonIcon = () => {
  return (
    <div>
      <Button icon="plus">添加</Button>
      <Button icon="align-left" />
    </div>
  );
};

/**
 * @title 圆形按钮
 */
import { Button } from 'amos-framework';

const ButtonCircle = () => {
  return (
    <div>
      <Button icon="plus" circle />
      <Button circle>赞</Button>
    </div>
  );
};

/**
 * @title transparent
 * @desc 文字颜色继承父级，背景透明
 */
import { Button } from 'amos-framework';

const ButtonTransparent = () => {
  return (
    <div>
      <Button icon="plus" transparent />
      <Button icon="align-left" transparent />
    </div>
  );
};

/**
 * @title 不可用的
 */
import { Button } from 'amos-framework';

const ButtonDisabled = () => {
  return (
    <div>
      <Button disabled>不可用</Button>
      <Button icon="plus" disabled />
    </div>
  );
};
