"use strict";
Object.defineProperty(exports, "__esModule", {
  value: !0
}), exports.commonGet = commonGet, exports.commonPost = commonPost, exports.commonPut = commonPut, exports.commonDelete = commonDelete, exports.getToken = getToken, exports.setToken = setToken, exports.getUser = getUser, exports.setUser = setUser, exports.compleHeaders = void 0;
var _amosProcessor = require("amos-processor"),
  _config = _interopRequireDefault(require("amos-processor/lib/config")),
  _amosTool = require("amos-tool"),
  _amosFramework = require("amos-framework"),
  _payload = _interopRequireDefault(require("./payload"));

function _interopRequireDefault(e) {
  return e && e.__esModule ? e : {
    default: e
  }
}

function ownKeys(o, e) {
  var r, t = Object.keys(o);
  return Object.getOwnPropertySymbols && (r = Object.getOwnPropertySymbols(o), e && (r = r.filter(function(e) {
    return Object.getOwnPropertyDescriptor(o, e).enumerable
  })), t.push.apply(t, r)), t
}

function _objectSpread(o) {
  for (var e = 1; e < arguments.length; e++) {
    var r = null != arguments[e] ? arguments[e] : {};
    e % 2 ? ownKeys(Object(r), !0).forEach(function(e) {
      _defineProperty(o, e, r[e])
    }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(o, Object.getOwnPropertyDescriptors(r)) : ownKeys(Object(r)).forEach(function(e) {
      Object.defineProperty(o, e, Object.getOwnPropertyDescriptor(r, e))
    })
  }
  return o
}

function _defineProperty(e, o, r) {
  return o in e ? Object.defineProperty(e, o, {
    value: r,
    enumerable: !0,
    configurable: !0,
    writable: !0
  }) : e[o] = r, e
}
var lsTool = _amosTool.Store.lsTool,
  defaultHeaders = function() {
    return window.isIotPluginsToAmos ? window.iotRequestInfo.staticHeader : {
      appKey: "AMOS_IOT",
      product: "AMOS_IOT_WEB"
    }
  },
  compleHeaders = function() {
    return _objectSpread(_objectSpread({}, defaultHeaders()), {}, {
      token: getToken()
    })
  };

function commonGet(e) {
  return (0, _amosProcessor.amosRequest)(e, {
    method: "GET",
    headers: compleHeaders(),
    reject: function(e) {
      console.log("请求失败，服务器错误！"), _amosFramework.message.danger(e.message || "请求失败，服务器错误！")
    }
  }).then(function(e) {
    return (0, _payload.default)(e)
  })
}

function commonPost(e, o, r) {
  return (0, _amosProcessor.amosRequest)(e, {
    headers: compleHeaders(),
    method: "POST",
    body: o,
    reject: function(e) {
      console.log("请求失败，服务器错误！"), _amosFramework.message.danger(e.message || "请求失败，服务器错误！")
    }
  }).then(function(e) {
    return (0, _payload.default)(e)
  })
}

function commonPut(e, o, r) {
  return (0, _amosProcessor.amosRequest)(e, {
    headers: compleHeaders(),
    method: "PUT",
    body: o,
    reject: function(e) {
      console.log("请求失败，服务器错误！"), _amosFramework.message.danger(e.message || "请求失败，服务器错误！")
    }
  }).then(function(e) {
    return (0, _payload.default)(e)
  })
}

function commonDelete(e, o, r) {
  return (0, _amosProcessor.amosRequest)(e, {
    headers: compleHeaders(),
    method: "DELETE",
    body: o,
    reject: function(e) {
      console.log("请求失败，服务器错误！"), _amosFramework.message.danger(e.message || "请求失败，服务器错误！")
    }
  }).then(function(e) {
    return (0, _payload.default)(e)
  })
}

function getToken() {
  return lsTool.read(_config.default.token)
}

function setToken(e) {
  return lsTool.write(_config.default.token, e)
}

function getUser() {
  return lsTool.read(_config.default.userId)
}

function setUser(e) {
  return lsTool.write(_config.default.userId, e)
}
exports.compleHeaders = compleHeaders;
