// import * as  _fetch from 'amos-processor/lib/fetch';
import { AmosFetch as oaf, XssAmosFetch as oxaf } from 'amos-processor';
import * as utils from 'amos-processor/lib/utils';
import AmosEnum from 'amos-processor/lib/enum/AmosEnum';
import * as permission from 'amos-processor/lib/config/permission';
import { utils as toolUtils, Store } from 'amos-tool';
import sysConsts from 'amos-processor/lib/config';

const lsTool = Store.lsTool;

const defaultHeaders = () => {
  return window.isIotPluginsToAmos ? window.iotRequestInfo.staticHeader : {
    appKey: 'AMOS_IOT',
    product: 'AMOS_IOT_WEB'
  };
}

export default{
  // ..._fetch,
  ...utils,
  AmosEnum,
  ...permission
};

export function getToken(){
  return lsTool.read(sysConsts.token);
}

export const AmosFetch = {
  _fetch(type) {
    return (url, params, data) => {
      if (!oaf[type]) {
        throw new Error(`AmosFetch: ´íÎóµÄÇëÇó[${type}]`);
      }
      const newParams = toolUtils.merge(
        {
          headers: {
            ...defaultHeaders(),
            token: getToken()
          },
          // ÆôÓÃ cookie£¬ `include, same-origin, *omit`
          // credentials: 'include'
        },
        params
      );
      return oaf[type](url, { params: newParams, data });
    };
  },
  get(url, { params, data } = {}) {
    return AmosFetch._fetch('get')(url, params, data);
  },
  put(url, { params, data } = {}) {
    return AmosFetch._fetch('put')(url, params, data);
  },
  post(url, { params, data } = {}) {
    return AmosFetch._fetch('post')(url, params, data);
  },
  del(url, { params, data } = {}) {
    return AmosFetch._fetch('del')(url, params, data);
  }
};
