import React, { Component } from 'react';
import PropTypes from 'prop-types';
import { Modal,Button } from 'amos-antd';
import classnames from 'classnames';
// import './style/modol.scss';
/**
 * 简单模态对话框
 * @class SimpleModal
 * @extends {Component}
 */
class SimpleModal extends Component {
  constructor(props) {
    super(props);
  }

  render() {
    const maskClosable = false;
    let { visible,wrapClassName,title,onCancel,width,onOk,style,children,footer,okText,cancelText,...other } = this.props;
    wrapClassName = classnames(wrapClassName, {
      'details-model': true
    });
    if (footer === undefined) {
      footer = [
        <Button type="primary" key='confirm-btn' htmlType='submit'  onClick={onOk}>{okText}</Button>,
        <Button type="ghost" key='cancle-btn'  onClick={onCancel}>{cancelText}</Button>
      ];
    }
    return (
      <aside>
        {
        visible &&
          <Modal
            visible={visible}
            title={title}
            onCancel={onCancel}
            onOk={onOk}
            width={width}
            maskClosable={maskClosable}
            style={style}
            wrapClassName={wrapClassName}
            footer={footer}
            {...other}
          >
            {children}
          </Modal>
        }
      </aside>
    );
  }
}

SimpleModal.propTypes = {
  visible: PropTypes.bool,//是否展示对话框
  wrapClassName: PropTypes.bool,//对话框外层容器的类名
  title: PropTypes.string,//标题
  onCancel: PropTypes.func,//点击遮罩层或右上角叉或取消按钮的回调
  onOk: PropTypes.func,//点击确定按钮的回调
  width: PropTypes.any,//宽度
  style: PropTypes.object,//可用于设置浮层的样式，调整浮层位置等
  children: PropTypes.any,//对话框内容
  footer: PropTypes.array,
  okText: PropTypes.string,
  cancelText: PropTypes.string
};

SimpleModal.defaultProps = {
  width: 500,
  okText: '确定',
  cancelText: '取消'
};

export default SimpleModal;
