import { bindActionCreators } from 'redux';
import { connect } from 'react-redux';
import companyAction from './../../model/company';

const mapState2Props = (state) => {
  let companyState = state.companyReducer;
  let companyLevels = companyState.getIn([ 'SEC_COMPANY','companyLevels' ]);
  let superiorCompanyList = companyState.getIn([ 'SEC_COMPANY','superiorCompanyList' ]);
  let editSuperiorCompanyList = companyState.getIn([ 'SEC_COMPANY','editSuperiorCompanyList' ]);
  let tableList = companyState.getIn([ 'SEC_COMPANY','tableList' ]);
  let companyInfo = companyState.getIn([ 'SEC_COMPANY','companyInfo' ]);
  let needRefreshTable = companyState.getIn([ 'SEC_COMPANY','needRefreshTable' ]);
  return {
    companyLevels,
    superiorCompanyList,
    editSuperiorCompanyList,
    companyInfo,
    tableList,
    needRefreshTable
  };
};

const actionCreators = (actions,bindActionCreators,dispatch) => {
  let keys = Object.keys(actions);
  keys.map(actionKey=>actions[actionKey] = bindActionCreators(actions[actionKey], dispatch));
  return actions;
};

const mapDispatch2Props = (dispatch,actions) => {
  return actionCreators(actions,bindActionCreators,dispatch);
};

const companyConnect = (base) => {
  return (ComposedComponent)=>connect(mapState2Props, (dispatch)=>mapDispatch2Props(dispatch,companyAction(base)))(ComposedComponent);
};

export default companyConnect;
