import React, { Component } from 'react';
import PropTypes from 'prop-types';
import { PubSub } from 'ray-eventpool';
import { CONFIG_PANEL_SHOW_TOPIC,SELECT_STATUS_CHANGE_TOPIC } from './../../common/ActionConf';

/**
 *
 *
 * @class QuotaCommonCell
 * @extends {Component}
 */
class QuotaCommonCell extends Component {
  constructor(props){
    super(props);
    let { content,updateQuotaCellStatus,equipment } = this.props;
    let enable = true;
    if (equipment !== undefined && equipment.id !== undefined) {
      let param = equipment.cfgParamMap.selCpblIds;
      if (param !== undefined && param.includes(`${content.id}`)) {
        enable = true;
      } else {
        enable = false;
      }
    }
    updateQuotaCellStatus(content.id,enable);
    this.usedState = enable;
    this.state = {
      change: true
    };
  }

  componentWillMount() {

  }

  componentDidMount(){

  }

  componentWillReceiveProps(nextProps) {
    let refreshCellStatus = nextProps.refreshCellStatus;
    if (refreshCellStatus) {
      let { content,updateQuotaCellStatus,equipment,changeRefreshCellStatus } = this.props;
      let enable = true;
      if (equipment !== undefined && equipment.id !== undefined) {
        let param = equipment.cfgParamMap.selCpblIds;
        if (param !== undefined && param.includes(`${content.id}`)) {
          enable = true;
        } else {
          enable = false;
        }
      }
      updateQuotaCellStatus(content.id,enable);
      changeRefreshCellStatus();
      this.usedState = enable;
    }
  }

  componentWillUnmount() {

  }

  getImgByState = () => {
    let content = [];
    if (this.usedState) {
      content.push(<img key={this.usedState} src={require('./../../../../assets/iot/deviceManage/disable.png')} alt='' />);
    } else {
      content.push(<img key={this.usedState} src={require('./../../../../assets/iot/deviceManage/enable.png')} alt='' />);
    }
    return content;
  }

  getStyleByState = () => {
    let usedState =  this.usedState;
    let { autoSelected } = this.props;
    if (autoSelected) {
      this.usedState = autoSelected;
      return 'quota-cell-enable-root';
    } else if (usedState) {
      return 'quota-cell-enable-root';
    } else {
      return 'quota-cell-disable-root';
    }
  }

  openConfigPanel = (status) => {
    let { content } = this.props;
    if (status !== true && status !== false) {
      status = undefined;
    }
    PubSub.publish(CONFIG_PANEL_SHOW_TOPIC.trigger, {
      type: 2,
      id: content.id,
      capacity: content,
      status
    });
  }

  changeEnableState = (e) => {
    e.stopPropagation();
    let { updateQuotaCellStatus,content,updateStatus } = this.props;
    let usedState = this.usedState;
    this.openConfigPanel(!usedState);
    this.usedState = !usedState;
    updateStatus(!usedState === true ? content.id : undefined);
    updateQuotaCellStatus(content.id,!usedState);
    this.setState({ change: this.state.change });
  }

  render() {
    let { content,enable } = this.props;
    let style = this.getStyleByState();
    return (
      <div className={style} onClick={this.openConfigPanel} >
        <div className='quota-cell-name'>{content.name}</div>
        <div className='quota-cell-desc'>{content.descr}</div>
        {enable ? <div className='quota-cell-img' onClick={this.changeEnableState} >
          {this.getImgByState()}
        </div> : ''}
      </div>
    );
  }
}

QuotaCommonCell.propTypes = {
  content: PropTypes.object,
  updateQuotaCellStatus: PropTypes.func,
  equipment: PropTypes.object,
  enable: PropTypes.bool,
  autoSelected: PropTypes.bool,
  updateStatus: PropTypes.func,
  refreshCellStatus: PropTypes.bool,
  changeRefreshCellStatus: PropTypes.func
};

export default QuotaCommonCell;
