import React, { Component } from 'react';
import PropTypes from 'prop-types';
import { Editable,Popover,Collapse,Input,Row,Col } from 'amos-framework';
import { PubSub } from 'ray-eventpool';
import { CONFIG_PANEL_HIDE_TOPIC } from './../../common/ActionConf';

const Panel = Collapse.Panel;
/**
 *
 *
 * @class InterfacePropertyPanel
 * @extends {Component}
 */
class InterfacePropertyPanel extends Component {
  constructor(props){
    super(props);
    this.state = {
      collapseKey: ['1','2'],
      interfaceProperty: {}//接口属性键值对
    };
  }
  componentWillMount() {

  }

  componentDidMount(){

  }

  componentWillReceiveProps(nextProps) {

  }

  componentWillUnmount() {

  }

  onAttributeChange = (key,e) => {
    let { interfaceProperty } = this.state;
    let { updateInterfacePropertyCell } = this.props;
    interfaceProperty[key] = e.target.value;
    updateInterfacePropertyCell(key,e.target.value);
    this.setState({ interfaceProperty });
  }

  //折叠面板区滑动条控制
  onChangeCollapseSize = (key) =>{
    if (key !== undefined && key.length !== undefined) {
      this.setState({ collapseKey: key });
    }
  }

  getBaseContent = () => {
    let content = [];
    let { intfc } = this.props;
    content.push(<div className='property-config-common'>
      <div title={'通信方式'} className='property-key-style'>
        {'通信方式'}：
      </div>
      <div style={{ width: '142px','float': 'left' }}>
        <div className='property-normal-label' title={intfc.name} >{intfc.name}</div>
      </div>
    </div>);
    return content;
  }

  getAttributesEditContent = () => {
    let content = [];
    let { intfc,updateInterfacePropertyCell,equipment,enable } = this.props;
    let { interfaceProperty } = this.state;
    intfc.attributes.map(item => {
      let value = interfaceProperty[`intfc_${intfc.id}_${item.id}`];
      if (value === undefined) {
        if (equipment !== undefined && equipment.id !== undefined) {
          let param = equipment.cfgParamMap;
          value = param[`intfc_${intfc.id}_${item.id}`] ? param[`intfc_${intfc.id}_${item.id}`] : value;
        } else {
          value = item.valueStr;
        }
      }
      interfaceProperty[`intfc_${intfc.id}_${item.id}`] = value;
      updateInterfacePropertyCell(`intfc_${intfc.id}_${item.id}`,value);
      content.push(<div className='property-config-common'>
        <div className='property-key-style' title={item.displayName}>
          {item.displayName}：
        </div>
        <div style={{ width: '142px','float': 'left' }}>
          {enable ? <Input
            value={value ? value : item.valueStr}
            onChange={(e) => this.onAttributeChange(`intfc_${intfc.id}_${item.id}`, e)}
            // showOkCancel={false}
            style={{ width: '140px' }}
            placeholder={'请输入'}
            // innerValueStyle={{ width: '140px' }}
            // useOnBlur={!enable}
            // defaultEditing={enable}
          />
        : <div className='property-normal-label' title={value ? value : item.valueStr} >{value ? value : item.valueStr}</div>}
        </div>
      </div>);
    });
    return content;
  }

  //折叠面板折叠操作区内容
  getCollapseHead = (name,index) => {
    let imgPath = this.props.getImgPath(index,this.state.collapseKey);
    let content = [];
    content.push(<div className='config-collapse-head'>
      <label className='config-collapse-text'>{name}</label>
      {imgPath}
    </div>);
    return content;
  }

  closeInterfacePanel = () => {
    PubSub.publish(CONFIG_PANEL_HIDE_TOPIC.trigger, {});
  }

  render() {
    let { collapseKey } = this.state;
    return (
      <div className='interface-property-root'>
        <div className='interface-property-head'>
          <div className='common-property-text'>接口详情</div>
          <div className='del-button-view' onClick={this.closeInterfacePanel}>关闭</div>
        </div>
        <Collapse activeKey={collapseKey}  onChange={key => this.onChangeCollapseSize(key)} >
          <Panel showArrow={false} header={this.getCollapseHead('设备接口','1')} key="1">
            <div className='interface-base-info'>
              {this.getBaseContent()}
            </div>
          </Panel>
          <Panel showArrow={false} header={this.getCollapseHead('通讯参数','2')} key="2">
            <div className='interface-property-info'>
              {this.getAttributesEditContent()}
            </div>
          </Panel>
        </Collapse>
      </div>
    );
  }
}

InterfacePropertyPanel.propTypes = {
  getImgPath: PropTypes.func,
  intfc: PropTypes.object,
  updateInterfacePropertyCell: PropTypes.func,
  equipment: PropTypes.object,
  enable: PropTypes.bool
};

export default InterfacePropertyPanel;
