import React, { Component } from 'react';
import PropTypes from 'prop-types';
import { Card,Row } from 'amos-antd';
import { interfaceDirectionEnum } from  './../../common/DeviceEnum';
import { stringUtil } from './../../common/DeviceLang';
import CommonCell from './../../common/CommonCell';
import AddDeviceInterface from './AddDeviceInterface';
import './../device-detail.scss';
import './../../common/common.scss';

/**
 * 新增接口card
 */
class AddDeviceInterfaceCard extends Component {
  constructor(props) {
    super(props);
    this.state = {
      interfaceProList: []
    };
  }

  componentWillMount(){

  }

  componentDidMount(){

  }

  componentWillReceiveProps(){

  }

  /**
   *
   * 新增后触发面板更新
   * @memberof AddDeviceInterfaceCard
   */
  autoCardCalculate= (newInterface) => {
    let interfaceProList = this.state.interfaceProList;
    if (newInterface !== undefined) {
      interfaceProList = [ ...interfaceProList, ...newInterface ];
      this.setState({ interfaceProList });
    }
    this.autoProView();
  }

  /**
   *
   * 面板更新实现
   * @memberof AddDeviceInterfaceCard
   */
  autoProView = (newInterface) => {
    let { repuestType,addDeviceInterface } = this.props;
    let interfaceProList = newInterface === undefined ? this.state.interfaceProList : newInterface;
    let antoView = [];
    antoView.push(<div key={0}>
      <AddDeviceInterface repuestType={repuestType} addDeviceInterface={addDeviceInterface} autoCardCalculate={this.autoCardCalculate} />
    </div>);
    if ( interfaceProList.length > 0 ){
      for (let interfacePro of interfaceProList) {
        let contentHtml = [];
        contentHtml.push(<p>接&emsp;&emsp;口：{interfacePro.displayName}</p>);
        contentHtml.push(<p>接口方向：{stringUtil(interfaceDirectionEnum,parseInt(interfacePro.intfcDirection))}</p>);
        antoView.push(
          <CommonCell key={interfacePro.key} contentHtml={contentHtml} cardKey={interfacePro.key} value={interfacePro} deleteCellProperty={this.deleteCellProperty} />);
      }
    }
    return antoView;
  }

  /**
   * 删除Card
   *
   * @memberof AddDevice
   */
  deleteCellProperty = (id) =>{
    //更新card用的数据
    let interfaceList = this.state.interfaceProList;
    let removedList = [];
    for (let value of interfaceList) {
      if (value.key !== id) {
        removedList.push(value);
      }
    }
    this.setState({ interfaceProList: removedList });
    //更新保存用的数据
    this.props.deleteCellInterface(id);
    //更新页面
    this.autoProView();
  }

  render() {
    return (
      <Row>
        {this.autoProView()}
      </Row>
    );
  }
}

AddDeviceInterfaceCard.propTypes = {
  form: PropTypes.any,
  repuestType: PropTypes.string,
  deleteCellInterface: PropTypes.func,
  addDeviceInterface: PropTypes.func
};

export default AddDeviceInterfaceCard;
