import React, { Component } from 'react';
import PropTypes from 'prop-types';
import { Modal,Button,Form } from 'amos-antd';
import { Select } from 'amos-framework';
import { AmosFetch } from '../../../../utils/processor';
import { OltSerUrl } from '../../../../consts/urlConsts';
import AddEditDeviceCapacity from './AddEditDeviceCapacity';
import { interfaceDirectionEnum } from  './../../common/DeviceEnum';
import { stringUtil } from './../../common/DeviceLang';
import './../device-detail.scss';

const createForm = Form.create();
const Option = Select.Option;
/**
 * 编辑能力
 */
class EditDeviceCapacity extends Component {
  constructor(props) {
    super(props);
    this.state = {
      protocolOption: [],
      interfaceOption: [],
      selectedInterfaceList: [],
      visible: false
    };
  }

  componentWillMount(){

  }

  componentDidMount(){
    this.getAllAvailableProtocols();
    this.getAllAvailableInterfaces(this.props);
  }

  componentWillReceiveProps(nextProps){
    if ( nextProps.deviceInterfaces !== undefined && (nextProps.deviceInterfaces !== this.props.deviceInterfaces)) {
      this.getAllAvailableInterfaces(nextProps);
    }
  }

  /**
   * 打开新增对话框
   */
  onClick = () => {
    this.setState({ visible: true });
  }

  getAllAvailableProtocols = (e) => {
    let finalCriterias = [];
    let defaultCriterias = {};
    finalCriterias.push(defaultCriterias);
    AmosFetch.post(OltSerUrl.protocolDataList,{ data: finalCriterias }).then(res => {
      if (res.ok) {
        return res.json();
      }
      else
      {
        throw new Error('从服务端获取数据失败！');
      }
    }).then((data)=>{
      if (data.result === 'SUCCESS'){
        if (data.dataList !== null){
          let protocolList = data.dataList;
          let protocolOption = protocolList.map((item)=>
            <Option key={item.id} value={`${item.id}`}>{item.name}</Option>);
          this.setState({ protocolOption });
        }
      }
    });
  }

  getAllAvailableInterfaces = (nextProps) => {
    let { deviceInterfaces,listInfo } = nextProps;
    let interfaceOption = [];
    let interfaceMap = {};
    for (let item of deviceInterfaces) {
      interfaceOption.push(<Option key={item.intfcId} value={`${item.intfcId}-${item.intfcDirection}`}>{`${item.intfcDisplayName}-${stringUtil(interfaceDirectionEnum, parseInt(item.intfcDirection))}`}</Option>);
      interfaceMap[parseInt(item.intfcId)] = item.intfcDisplayName;
    }
    let selectedInterfaceList = [];
    listInfo.interfaceInfo.map((item) => {
      selectedInterfaceList.push(`${item.intfcId}-${item.intfcDirection}`);
    });
    this.setState({ interfaceOption,interfaceMap,selectedInterfaceList });
  }

  /**
   * 关闭新增对话框
   */
  handCancel = () => {
    this.props.form.resetFields();
    this.setState({ visible: false });
  }

  render() {
    let { form,listInfo,deviceId,protocolId,capacityId,getDeviceInfoById,deleteCurrentDeviceProperty } = this.props;
    let { protocolOption,interfaceOption,selectedInterfaceList,interfaceMap } = this.state;
    return (
      <div className='capacity-detail-property-button'>
        <div className='device-cell-delete-button' onClick={deleteCurrentDeviceProperty}>
          <img src={require('./../../../../assets/iot/img/mk_delect.png')} alt='' />
          <label>删除</label>
        </div>
        <div className='device-capacity-button' onClick={this.onClick}>
          <img src={require('./../../../../assets/iot/img/list_edit.png')} alt='' />
          <label>编辑</label>
        </div>
        <Modal maskClosable={false} title='编辑设备能力' closable visible={this.state.visible} onCancel={this.handCancel} width={500} footer={null} >
          <AddEditDeviceCapacity
            form={form}
            callBack={this.handCancel}
            listInfo={listInfo}
            deviceId={deviceId}
            protocolId={protocolId}
            interfaceOption={interfaceOption}
            protocolOption={protocolOption}
            selectedInterfaceList={selectedInterfaceList}
            capacityId={capacityId}
            interfaceMap={interfaceMap}
            getDeviceInfoById={getDeviceInfoById}
            {...this.props}
          />
        </Modal>
      </div>
    );
  }
}

EditDeviceCapacity.propTypes = {
  form: PropTypes.any,
  listInfo: PropTypes.any,
  deviceId: PropTypes.number,
  deviceInterfaces: PropTypes.array,
  protocolId: PropTypes.number,
  capacityId: PropTypes.number,
  getDeviceInfoById: PropTypes.func,
  deleteCurrentDeviceProperty: PropTypes.func
};

export default createForm(EditDeviceCapacity);
