import React, { Component } from 'react';
import PropTypes from 'prop-types';
import { Modal } from 'amos-antd';
import { AmosFetch } from '../../../../utils/processor';
import { OltSerUrl } from '../../../../consts/urlConsts';
import { message } from 'amos-framework';
import CapacityInterfaceCell from './CapacityInterfaceCell';
import AddCapacityInterface from './../deviceAddEdit/AddCapacityInterface';
import './../device-detail.scss';

/**
 * 设备接口
 *
 * @class CapacityInterface
 * @extends {Component}
 */
class CapacityInterface extends Component {
  constructor(props) {
    super(props);
    this.state = {

    };
  }

  componentDidMount(){

  }

  /**
   * 取设备接口
   *
   * @memberof PrivateDeviceDetail
   */
  fetchCapacityInterface = (e) => {
    let { interfaceInfo } = this.props;
    //测试
    let list = [];
    if (interfaceInfo !== undefined) {
      interfaceInfo.map(value=>{
        list.push(<CapacityInterfaceCell key={value.capaIntId} propertyInfo={value} deleteInterfaceProperty={this.deleteInterfaceProperty} {...this.props} />);
      });
    }
    return list;
  }

  /**
   * 删除设备接口
   *
   * @memberof PrivateDeviceDetail
   */
  deleteInterfaceProperty = (id) => {
    let delfunc = this.delInterface;
    Modal.confirm({
      title: '删除',
      content: '是否删除所选属性？',
      okText: '确定',
      cancelText: '取消',
      onOk() { delfunc(id); },
      onCancel() { }
    });
  }

  delInterface = (id) => {
    //删除数据库
    let url = `${OltSerUrl.deleteCapacityInterface}/${id}`;
    AmosFetch.del(url).then(res => {
      if (res.ok) {
        return res.text();
      }
      else
      {
        throw new Error('从服务端获取数据失败！');
      }
    }).then((data)=>{
    //重新刷新数据
      message.success('删除成功！');
      this.props.getDeviceInfoById(this.props.deviceId);
    });
  }

  render() {
    let { getDeviceInfoById,interfaceInfo,deviceId,capacityId,protocolId,visibility } = this.props;
    return (
      <div className='capacity-interface'>
        <div className='capacity-detail-interface'>
          <label>设备接口</label>
          {visibility ===1?
             <AddCapacityInterface
             deviceId={deviceId}
             capacityId={capacityId}
             interfaceInfo={interfaceInfo}
             getDeviceInfoById={getDeviceInfoById}
             protocolId={protocolId}
             {...this.props}
           />:null}

        </div>
        <div className='capacity-detail-interface-content'>
          {this.fetchCapacityInterface()}
        </div>
      </div>
    );
  }
}

CapacityInterface.propTypes = {
  interfaceInfo: PropTypes.array,
  deviceId: PropTypes.number,
  getDeviceInfoById: PropTypes.func,
  capacityId: PropTypes.number,
  protocolId: PropTypes.number
};

export default CapacityInterface;
