import React, { Component } from 'react';
import PropTypes from 'prop-types';
import { Modal } from 'amos-antd';
import { AmosFetch } from '../../../../utils/processor';
import { OltSerUrl } from '../../../../consts/urlConsts';
import { message } from 'amos-framework';
import DeviceCapacityCell from './DeviceCapacityCell';
import AddDeviceCapacity from './../deviceAddEdit/AddDeviceCapacity';
import './../device-detail.scss';

/**
 * 设备能力
 *
 * @class DeviceCapacity
 * @extends {Component}
 */
class DeviceCapacity extends Component {
  constructor(props) {
    super(props);
    this.state = {
      capaCityList: []
    };
  }

  componentDidMount(){

  }

  componentWillReceiveProps(nextProps) {
    if ( nextProps.device !== undefined && (nextProps.deviceInterfaces !== this.props.deviceInterfaces || nextProps.device !== this.props.device)) {
      this.fetchDeviceCapacity(nextProps);
    }
  }

  updateNewInfo =()=>{
    this.fetchDeviceCapacity(this.props);
  }

  /**
   * 取设备能力
   *
   * @memberof PrivateDeviceDetail
   */
  fetchDeviceCapacity = (nextProps) => {
    let { device,getDeviceInfoById,deviceInterfaces } = nextProps;
    let deviceCapacityList = device.capabilities;
    let list = [];
    if (deviceCapacityList && deviceCapacityList.length > 0) {
      for (let index = 0; index < deviceCapacityList.length; index++) {
        let value = deviceCapacityList[index];
        let url = `${OltSerUrl.fetchCapacityListInfoById}/${value.id}`;
        AmosFetch.get(url).then(res => {
          if (res.ok) {
            return res.json();
          }
          else
          {
            throw new Error('从服务端获取数据失败！');
          }
        }).then((data)=>{
          if (data.result === 'SUCCESS'){
            let dataList = data.dataList;
            if (dataList) {
              let interfaceList = dataList.interface;
              let propertyList = dataList.property;
              let protocolName = dataList.protocolName;
              let protocolId = value.protocolId;
              Object.assign(value,{ interfaceInfo: interfaceList,protocolName,propertyInfo: propertyList });
              list.push(<DeviceCapacityCell
                protocolId={protocolId}
                capacityId={value.id}
                deviceId={device.id}
                getDeviceInfoById={getDeviceInfoById}
                key={index}
                listInfo={value}
                deleteCapacityProperty={this.deleteCapacityProperty}
                addCapacityProperty={this.addCapacityProperty}
                deviceInterfaces={deviceInterfaces}
                updateNewInfo={this.updateNewInfo}
                visibility={device.visibility}
              />);
            }
          }
          if (index === deviceCapacityList.length - 1 ) {
            this.setState({ capaCityList: list });
          }
        });
      }
    } else {
      this.setState({ capaCityList: [] });
    }
  }

  /**
   * 删除设备接口
   *
   * @memberof PrivateDeviceDetail
   */
  deleteCapacityProperty = (id) => {
    let delfunc = this.delCapacity;
    Modal.confirm({
      title: '删除',
      content: '是否删除所选属性？',
      okText: '确定',
      cancelText: '取消',
      onOk() { delfunc(id); },
      onCancel() { }
    });
  }

  addCapacityProperty = () => {
    let deviceId = this.props.device.id;
    this.props.getDeviceInfoById(deviceId);
  }

  delCapacity = (id) => {
    let deviceId = this.props.device.id;
    //删除数据库
    let url = `${OltSerUrl.deleteDeviceCapacity}/${id}`;
    AmosFetch.del(url).then(res => {
      if (res.ok) {
        return res.text();
      }
      else
      {
        throw new Error('从服务端获取数据失败！');
      }
    }).then((data)=>{
    //重新刷新数据
      message.success('删除成功！');
      this.props.getDeviceInfoById(deviceId);
    });
  }

  render() {
    let { capaCityList } = this.state;
    let { device,getDeviceInfoById, deviceInterfaces } = this.props;
    return (
      <div className='device-capacity'>
        <div className='device-detail-capacity'>
          <label>数据采集</label>
          {device.visibility === 1 ? <AddDeviceCapacity deviceInterfaces={deviceInterfaces} deviceId={device.id} visibility={device.visibility} getDeviceInfoById={getDeviceInfoById} /> : null}
        </div>
        <div className='device-detail-capacity-content'>
          {capaCityList}
        </div>
      </div>
    );
  }
}

DeviceCapacity.propTypes = {
  device: PropTypes.object,
  getDeviceInfoById: PropTypes.func,
  deviceInterfaces: PropTypes.array
};

export default DeviceCapacity;
