import React, { Component } from 'react';
import { browserHistory } from 'amos-react-router';
import { Store, LocationParam } from 'amos-tool';
import SysConsts from 'amos-processor/lib/config/consts';
import { AmosAlert } from 'amos-framework';

import { login } from '../../services/securityService';

const lsTool = Store.lsTool;

/**
 * 自动登录，无界面
 *  BaseAutoLogin： props => `tip: string` `hideTip: boolean`
 * @class AutoLogin
 * @extends {Component}
 */
class AutoLogin extends Component {

  componentWillMount() {
    let token = LocationParam.getLocationParamByName('token');
    if (token) {
      browserHistory.push('/region');
    } else {
      AmosAlert.error('警告', '无法打开该系统，请重新尝试!');
    }
  }

  render() {
    return null;
  }
}

export default AutoLogin;
