import React, { Component } from 'react';
import PropTypes from 'prop-types';
import { Tabs,Select,Input } from 'amos-antd';
import RecentAlarmTable from './table/RecentAlarmTable';
import HistoryAlarmTable from './../historyAlarm/table/HistoryAlarmTable';
import BatchClearAlarm from './table/BatchClearAlarm';
import './alarm.scss';

const Option = Select.Option;
const TabPane = Tabs.TabPane;
const alarmLevel = [{ name: '全部',value: '-1' },{ name: '一级',value: '1' },{ name: '二级',value: '2' },{ name: '三级',value: '3' }];
const alarmType = [{ name: '全部',value: '-1' },{ name: '指标越界',value: 1 },{ name: '采集异常',value: 2 },{ name: '设备掉线',value: 3 }];
/**
 *
 *
 * @class AlarmManageMent
 * @extends {Component}
 */
class AlarmManageMent extends Component {
  constructor(props){
    super(props);
    this.state = {
      selectedKey: '1',
      filterCondition: {}
    };
  }
  componentWillMount() {

  }

  componentDidMount(){

  }

  componentWillReceiveProps(nextProps) {

  }

  componentWillUnmount() {

  }

  getOperation = () => {
    let content = [];
    let { selectedKey,filterCondition } = this.state;
    content.push(<div className='alarm-refresh'  title={'刷新'} onClick={this.refreshAlarm}>
      <img src={require('./../../assets/iot/alarm/refresh.png')} alt='' />
    </div>);
    if (selectedKey === '1' && this.refs.currentAlarmChild) {
      let deleteAction = this.refs.currentAlarmChild.batchClearAlarm;
      let getDataAction = this.refs.currentAlarmChild.getSelectedRowKeys;
      content.push(<BatchClearAlarm title='批量清除' type='batch' selectedRowKeys={getDataAction} clearAlarm={deleteAction} btnType='primary' size='default' />);
      let time = this.refs.currentAlarmChild.getRefreshTime();
      content.push(<div style={{ float: 'right','background-color': '#E3E3E3',height: '50px','line-height': '50px','font-size': '16px' }}>{time}</div>);
    } else if (selectedKey === '2' && this.refs.historyAlarmChild) {
      let deleteAction = this.refs.historyAlarmChild.batchClearAlarm;
      content.push(<div className='alarm-delete' title={'批量删除'} onClick={deleteAction}>
        <img src={require('./../../assets/iot/alarm/delete.png')} alt='' />
      </div>);
      let time = this.refs.historyAlarmChild.getRefreshTime();
      content.push(<div style={{ float: 'right','background-color': '#E3E3E3',height: '50px','line-height': '50px','font-size': '16px' }}>{time}</div>);
    } else {
      let time = this.getCurrentTime();
      content.push(<div style={{ float: 'right','background-color': '#E3E3E3',height: '50px','line-height': '50px','font-size': '16px' }}>{time}</div>);
    }
    content.push(<div style={{ float: 'right','background-color': '#E3E3E3',height: '50px','line-height': '50px','font-size': '16px' }}>告警刷新时间:</div>);
    content.push(<div className='current-alarm-input'>
      <Input placeholder="告警源" value={filterCondition.name} onChange={this.onChange} />
    </div>);
    content.push(<div className='current-alarm-select'>
      <Select
        style={{ width: '160px' }}
        dropdownStyle={{ width: '160px' }}
        dropdownMatchSelectWidth
        onChange={(e)=>this.onSelectedChange(e,'type')}
        placeholder='告警类型'
        allowClear
        value={filterCondition.type}
      >
        {
          alarmType.map(e => (
            <Option key={e.value} value={e.value}>{e.name}</Option>
        ))
      }
      </Select>
    </div>);
    content.push(<div className='current-alarm-select'>
      <Select
        style={{ width: '160px' }}
        dropdownStyle={{ width: '160px' }}
        dropdownMatchSelectWidth
        onChange={(e)=>this.onSelectedChange(e,'level')}
        placeholder='告警级别'
        allowClear
        value={filterCondition.level}
      >
        {
          alarmLevel.map(e=>(
            <Option key={e.value} value={e.value}>{e.name}</Option>
          ))
        }
      </Select>
    </div>);
    return content;
  }

  onSelectedChange = (value,type) => {
    let { filterCondition } = this.state;
    filterCondition[type] = value;
    this.setState({ filterCondition });
    let { selectedKey } = this.state;
    let filter = {
        current: 0,
        pageSize: 10
    };
    if('level' === type){
       //选择告警级别
       filterCondition.level = value;
    }else if('type' === type){
       //选择告警类型
       filterCondition.type = value;
    }
    if (selectedKey === '1' && this.refs.currentAlarmChild) {
      let refreshData = this.refs.currentAlarmChild.refreshData;
      refreshData(filter, filterCondition);
    } else if (selectedKey === '2' && this.refs.historyAlarmChild) {
      let refreshData = this.refs.historyAlarmChild.refreshData;
      refreshData(filter, filterCondition);
    }

  }

  onChange = (e) => {
    let { filterCondition } = this.state;
    filterCondition.name = e.target.value;
    this.setState({ filterCondition });
    let { selectedKey } = this.state;
    let filter = {
      current: 0,
      pageSize: 10
  };
    if (selectedKey === '1' && this.refs.currentAlarmChild) {
      let refreshData = this.refs.currentAlarmChild.refreshData;
      refreshData(filter, filterCondition);
    } else if (selectedKey === '2' && this.refs.historyAlarmChild) {
      let refreshData = this.refs.historyAlarmChild.refreshData;
      refreshData(filter, filterCondition);
    }
  }

  changeSelected = (key) => {
    this.setState({ filterCondition: {} });
    this.refreshAlarm();
    this.setState({ selectedKey: key });
  }

  getCurrentTime = () => {
    let myDate = new Date();
    let hours = myDate.getHours();
    let minutes = myDate.getMinutes();
    if (minutes < 10){
      minutes = `0${minutes}`;
    }
    let refreshTime = `${hours}时${minutes}分`;
    return refreshTime;
  }

  refreshAlarm = () => {
    let { selectedKey } = this.state;
    if (selectedKey === '1' && this.refs.currentAlarmChild) {
      this.refs.currentAlarmChild.refreshTime();
    } else if (selectedKey === '2' && this.refs.historyAlarmChild) {
      this.refs.historyAlarmChild.refreshTime();
    }
    this.setState({ selectedKey });
  }

  updateStatus = () => {
    this.setState({ selectedKey: this.state.selectedKey });
  }

  render() {
    return (
      <Tabs type="card" tabBarExtraContent={this.getOperation()} onChange={this.changeSelected}>
        <TabPane tab="当前告警" key="1">
          <RecentAlarmTable ref='currentAlarmChild' updateStatus={this.updateStatus} {...this.props} />
        </TabPane>
        <TabPane tab="历史告警" key="2">
          <HistoryAlarmTable ref='historyAlarmChild' updateStatus={this.updateStatus} />
        </TabPane>
      </Tabs>
    );
  }
}

AlarmManageMent.propTypes = {

};

export default AlarmManageMent;
