import React, { Component } from 'react';
import PropTypes from 'prop-types';
import { Modal,Row,Col,Input } from 'amos-antd';

/**
 *
 * @class BatchClearAlarm
 * @extends {Component}
 */
class BatchClearAlarm extends Component {
  constructor(props) {
    super(props);
    this.state = {
      visible: false,
      inputStr: '告警已处理！'
    };
  }
  /**
   * 初始化
   */
  componentDidMount() {

  }

  /**
   * 打开新增监测规则对话框
   */
  onClick = () => {
    if (this.props.type === 'one'){
      this.setState({ visible: true });
    } else {
      if (this.props.selectedRowKeys().length === 0){
        const modal = Modal.warning({
          title: '系统提示',
          content: '请选择数据！',
          okText: '确定'
        });
        setTimeout(() => modal.destroy(), 2000);
      } else {
        this.setState({ visible: true });
      }
    }
  }

  onChange = (e) =>{
    this.setState({
      inputStr: e.target.value
    });
  }
  /**
   * 关闭新增监测规则对话框
   */
  handleCancel = () => {
    this.setState({ visible: false });
  }

  handleSubmit = () => {
    this.handleCancel();
    let ids = [];
    if (this.props.type === 'one'){
      ids.push(this.props.alarmId);
    } else {
      ids = this.props.selectedRowKeys();
    }
    let { inputStr } = this.state;
    this.props.clearAlarm(inputStr,ids);
  }

  render() {
    let destroyOnClose = true;
    let maskClosable = false;
    let { inputStr } = this.state;
    return (
      <div className='alarm-delete' title='批量清除'>
        <img src={require('./../../../assets/iot/alarm/delete.png')} onClick={this.onClick} alt='' />
        {/*<Button type={btnType} size={size} onClick={this.onClick} style={{ marginLeft:'10px' }} >{title}</Button>*/}
        <Modal width={333} className='clear-alarm-modal' title='清除告警信息' visible={this.state.visible}  footer={null} onCancel={this.handleCancel} maskClosable={maskClosable} destroyOnClose={destroyOnClose} >
          <div>
            <Row style={{ marginTop: '20px',textAlign: 'center' }} >
              <Col span={24}>
                <span style={{ 'font-size': '13px' }}>备注：</span><Input value={inputStr} style={{ width: '250px','font-size': '13px' }} onChange={this.onChange} />
              </Col>
            </Row>
          </div>
          <Row style={{ 'padding-top': '30px' }}>
            <Col className='alarm-detail-clear' span={4} offset={6} onClick={this.handleSubmit}>
              确定
            </Col>
            <Col className='alarm-detail-cancel' span={4} offset={2} onClick={this.handleCancel}>
              取消
            </Col>
          </Row>
        </Modal>
      </div>
    );
  }
}

BatchClearAlarm.propTypes = {
  title: PropTypes.any,
  selectedRowKeys: PropTypes.func,
  clearAlarm: PropTypes.func,
  alarmId: PropTypes.string,
  type: PropTypes.string
};

BatchClearAlarm.defaultProps = {
};
export default BatchClearAlarm;
