import React, { Component } from 'react';
import PropTypes from 'prop-types';

import RuleEleList from './RuleEleList';

import PropertyHeader from './../header/PropertyHeader';
import { nodelList as defaultModeList } from './../modelConf/stageConf';
import { fetchRuleElementsAction } from './../../../../services/ruleDesignService';

class PropertiesBar extends Component {

  constructor(props) {
    super(props);
    this.state = {
      nodelList: []
    };
  }

  componentDidMount() {
    this.fetchRuleElements();
  }

  onNodeChange = (value) => {
    // 进行过滤
  }

  fetchRuleElements = () => {
    fetchRuleElementsAction().then(data => {
      this.setState({ nodelList: data });
    });
  }

  render() {
    const { nodelList } = this.state;
    const { addNode } = this.props;
    return (
      <div className="rule-property-bar">
        <div className="rule-property-head">
          <div className="rule-property-text">
            规则节点
          </div>
        </div>
        <div className="rule-property-content">
          <RuleEleList addNode={addNode} nodelList={nodelList} />
        </div>
      </div>
    );
  }
}

PropertiesBar.propTypes = {
  addNode: PropTypes.func
};

export default PropertiesBar;
