import React, { Component } from 'react';
import PropTypes from 'prop-types';
import { AmosPlumbProd, AmosPlumb, setting } from 'amos-jsplumb';

import { jsPlumbOptions } from './modelConf/nodeConf';
import getComponent from './ele/customElelist';

const { dottedConnectionStyle, selectedConnectionStyle, defaultSettings } = setting;
const registerTypes = {
  connections: {
    dotted: dottedConnectionStyle,
    selected: selectedConnectionStyle
  },
  endpoints: {}
};

/**
 * 场景(画布)
 *
 * @class TopoStagePlumb
 * @extends {Component}
 */
class TopoStagePlumb extends Component {
  static propTypes = {
    dataSource: PropTypes.shape({
      nodes: PropTypes.array,
      connections: PropTypes.array
    }),
    handleDrop: PropTypes.func,
    onPlumbChange: PropTypes.func,
    onSceneCreated: PropTypes.func,
    onPlumbClick: PropTypes.func,
    destroy: PropTypes.bool,
    eventListeners: PropTypes.object,
    onAddConnection: PropTypes.func,
    zoom: PropTypes.number,
    onZoom: PropTypes.func,
    onRemoveConnection: PropTypes.func,
    onRemoveNode: PropTypes.func,
    nodeProps: PropTypes.object
  };

  render() {
    const { dataSource, onPlumbChange, onSceneCreated, onPlumbClick, eventListeners, destroy, onAddConnection,
       zoom, onZoom, onRemoveConnection, onRemoveNode, nodeProps } = this.props;

    const { nodes, connections } = dataSource;
    return (
      <AmosPlumb
        className="amos-plumb-container"
        key="amos-plumb"
        onCreated={onSceneCreated}
        nodes={nodes}
        connections={connections}
        eventListeners={eventListeners}
        registerTypes={registerTypes}
        onChange={onPlumbChange}
        onPlumbClick={onPlumbClick}
        // jsPlumbOptions={jsPlumbOptions}
        jsPlumbSettings={defaultSettings}
        getNodeContent={getComponent}
        destroy={destroy}
        zoom={zoom}
        showControl
        draggableOptions={{
          constrain: true
        }}
        onAddConnection={onAddConnection}
        onRemoveConnection={onRemoveConnection}
        onRemoveNode={onRemoveNode}
        onZoom={onZoom}
        nodeProps={nodeProps}
      />
    );
  }
}

export default TopoStagePlumb;
