import React, { Component } from 'react';
import PropTypes from 'prop-types';
import { AmosFetch } from '../../../utils/processor';
import { OltSerUrl } from '../../../consts/urlConsts';
import { Modal } from 'amos-antd';
import { message } from 'amos-framework';
import TopoTree from './TopoTree';
import TopoMangent from './topoMangent';

/**
 *
 *拓扑视图
 * @class TopoView
 * @extends {Component}
 */
class TopoView extends Component {
  constructor(props) {
    super(props);
    this.state = {
      subviewId: 0,
      subviewName: '',
      currentNode: {},
      selectedKeys: [],
      subviewList: []
    };
  }

  componentDidMount() {

  }

  //设置当前子图
  setCurrentSubviewId = (subviewId,subviewName,currentNode,selectedKeys,expandedKeys) => {
    this.getSubviewByOrgCode(subviewId);
    this.setState({ subviewId,subviewName,currentNode,selectedKeys,expandedKeys });

  }

  getSubviewByOrgCode = (subviewId) => {
    let url = `${OltSerUrl.getSubviewByOrgCode}/${subviewId}`;
    AmosFetch.get(url).then(res => {
      if (res.ok) {
        return res.json();
      }
      else
      {
        throw new Error('从服务端获取数据失败！');
      }
    }).then((data)=>{
      if (data.result === 'SUCCESS'){
        let subviewList = data.dataList;
        this.setState({ subviewList });
      } else {
        let subviewList = [];
        this.setState({ subviewList });
      }
    });
  }

  setCurrentName = (subviewName) => {
    this.setState({ subviewName });
  }
  //删除元素
  delSubgraph = (nodeKey) => {
    let url = `${OltSerUrl.delSubgraph}/${nodeKey}`;
    AmosFetch.del(url).then(res => {
      if (res.ok) {
        return res.text();
      }
      else
      {
        throw new Error('从服务端获取数据失败！');
      }
    }).then((data)=>{
    //重新刷新数据
      message.success('删除成功！');
      //界面刷新
      this.getSubviewByOrgCode(this.state.subviewId);
    });
  }

  render() {
    let { subviewId,subviewList,subviewName,expandedKeys } = this.state;
    return (
      <div className="topo-root">
        <div className='topo-view-head' >物理拓扑图</div>
        <TopoTree setCurrentSubviewId={this.setCurrentSubviewId} setCurrentName={this.setCurrentName} {...this.props} />
        <TopoMangent subviewList={subviewList} orgId={subviewId} treeName={subviewName} treeKey={expandedKeys} getSubviewByOrgCode={this.getSubviewByOrgCode} delSubgraph={this.delSubgraph} {...this.props} />
      </div>
    );
  }
}

TopoView.propTypes = {

};

export default TopoView;
