import React, { Component } from 'react';
import PropTypes from 'prop-types';
import { Row } from 'amos-antd';

/**
 * 设备属性能力
 */
class DeviceProNode extends Component {
  constructor(props) {
    super(props);
    this.state = {
    };
  }

  formatTime(time){
    let date = new Date(time);
    date = date.format('yyyy-MM-dd hh:mm:ss')
    return date;
  }

  getView = () =>{
    let view = [];
    let dataList = this.props.dataList;
    if (dataList === undefined) {
      return;
    }
    dataList.map((data, i)=>{
      const key = `dpn-${i}`;
      if (data.metricDataMap && JSON.stringify(data.metricDataMap) !== '{}'){
        view.push(<Row key={key}><h3 className="node-popover-ability">{data.cpblName}</h3></Row>);
        // view.push(<Row key={key} style={{ margin: '0px 5px 5px 10px' }} ><span>数据推送时间：{this.formatTime(data.time)}</span></Row>);
        console.log('数据推送时间：' + this.formatTime(data.time));
        let obj = data.metricDataMap;
        for (let i in obj){
          console.log(i);
          let title = `${i}：${obj[i]}`;
          view.push(<Row key={key} style={{ margin: '0px 5px 5px 10px' }} ><span>{title}</span></Row>);
        }
      }
    });
    return view;
  }
  render() {
    return (
      <div className='node-popover-custom'>
        {this.getView()}
      </div>
    );
  }
}

DeviceProNode.propTypes = {
  dataList: PropTypes.any
};

export default DeviceProNode;
