import React, { Component } from 'react';
import PropTypes from 'prop-types';
import classNames from 'classnames';
import Header from './../../../common/header/Header';

/**
 * tree header
 *
 * @class NodeHeader
 * @extends {Component}
 */
class NodeHeader extends Component {

  static propTypes = {
    className: PropTypes.string,
    extra: PropTypes.node,
    title: PropTypes.node
  };

  constructor(props) {
    super(props);
    this.state = {
      value: ''
    };
  }

  render() {
    const { title, className, extra } = this.props;

    const cls = classNames('topo-node-header', className);

    return (
      <div className={cls}>
        <Header
          title={title}
          extra={extra}
        />
      </div>
    );
  }
}

export default NodeHeader;
