import React, { Component } from 'react';
import PropTypes from 'prop-types';
import { Collapse,Editable } from 'amos-framework';
import { Select } from 'amos-antd';
import { monitorTypeArr,periodArr } from './../../../createEquipment/common/TaskEnum';
import { updateEquipmentConfigAction } from './../../../../services/topoService';

const Panel = Collapse.Panel;
const Option = Select.Option;
/**
 *
 *
 * @class DeviceCapacityInfoConfig
 * @extends {Component}
 */
class DeviceCapacityInfoConfig extends Component {
  constructor(props){
    super(props);
    this.taskParams = {};//存放各能力的任务周期
    this.interfaceProperty = {};//接口属性键值对
    this.state = {
      collapseKey: this.onInitCollapsePanel(props.currentDeviceConfig)
    };
  }
  componentWillMount() {

  }

  componentDidMount(){

  }

  componentWillReceiveProps(nextProps) {
    if (nextProps.currentDeviceConfig !== this.props.currentDeviceConfig) {
      this.onInitCollapsePanel(nextProps.currentDeviceConfig);
    }
  }

  componentWillUnmount() {

  }

  onInitCollapsePanel = (currentDeviceConfig) => {
    let capacities = currentDeviceConfig ? currentDeviceConfig.cpbl : undefined;
    let count = 0;
    let collapseKey = [];
    capacities && capacities.map(item => {
      count = count + 1;
      collapseKey.push(count.toString());
    });
    return collapseKey;
  }

  //折叠面板区滑动条控制
  onChangeCollapseSize = (key) =>{
    if (key !== undefined && key.length !== undefined) {
      this.setState({ collapseKey: key });
    }
  }

  onTaskAttributeChange = (newTask,cpbId,value) => {
    let { equipmentId,nodeId,showProperty } = this.props;
    newTask.monitorPeriod = value;
    let postData = {
      id: equipmentId,
      task: newTask
    };
    updateEquipmentConfigAction(postData).then(res => {
      let taskParams = this.taskParams;
      taskParams[cpbId] = value;
      this.taskParams = taskParams;
      showProperty(nodeId);
    });
  }

  onInterfaceAttributeChange = (key,value) => {
    let { equipmentId,nodeId,showProperty } = this.props;
    let postData = {
      id: equipmentId
    };
    postData[key] = value;
    updateEquipmentConfigAction(postData).then(res => {
      let interfaceProperty  = this.interfaceProperty;
      interfaceProperty[key] = value;
      this.interfaceProperty = interfaceProperty;
      showProperty(nodeId);
    });
  }

  //折叠面板折叠操作区内容
  getCollapseHead = (name,index) => {
    let imgPath = this.props.getImgPath(index,this.state.collapseKey);
    let content = [];
    content.push(<div className='config-collapse-head'>
      <label className='config-collapse-text'>{name}</label>
      {imgPath}
    </div>);
    return content;
  }

  getCapaityContent = () => {
    let { currentDeviceConfig } = this.props;
    let capacities = currentDeviceConfig ? currentDeviceConfig.cpbl : undefined;
    let content = [];
    let count = 0;
    capacities && capacities.map(item => {
      count = count + 1;
      let capacity = item.cpbl;
      let protocol = item.protocol;
      let task = item.task;
      //处理taskParas
      let taskParams = this.taskParams;
      let taskParam = taskParams[capacity.id];
      if (taskParam === undefined) {
        taskParam = task.monitorPeriod === 0 ? undefined : task.monitorPeriod;
        taskParams[capacity.id] = taskParam;
        this.taskParams = taskParams;
      }
      //intfc
      let intfc = item.intfc;
      let intfcProperty = item.intfcProperty;
      //tasktype
      let monitorType = task.monitorType;
      let monitorTypeName = '';
      monitorTypeArr.map(item => {
        if (item.value === monitorType) {
          monitorTypeName = item.title;
        }
      });
      //监听模式没有轮训时间配置
      let enableSelect = false;
      if (monitorType === 2) {
        enableSelect = true;
      }
      content.push(<Panel showArrow={false} header={this.getCollapseHead(capacity.name,count.toString())} key={count.toString()} >
        <div className='device-capacity-info'>
          <div className='topo-capacity-common'>
            <div className='property-label-name'>通信协议：</div>
            <div className='property-normal-label' title={protocol && protocol.name}>{protocol && protocol.name}</div>
          </div>
          <div className='topo-capacity-common'>
            <div className='property-label-name'>监测方式：</div>
            <div className='property-normal-label' title={monitorTypeName}>{monitorTypeName}</div>
          </div>
          {enableSelect?'':
          <div className='topo-capacity-common'>
            <div className='property-label-name'>采集周期：</div>
            <div className='property-normal-select'>
              <Select disabled={enableSelect} value={taskParam} style={{ width: 91 }} placeholder='请选择' onSelect={e => this.onTaskAttributeChange(task,capacity.id,e)} >
                {
                  periodArr.map(data => <Option key={data.value} value={data.value}>{data.title}</Option>)
                }
              </Select>
            </div>
          </div>}
          <div className='topo-capacity-common'>
            <div className='property-label-name'>通信方式：</div>
            <div className='property-normal-label' title={intfc && intfc.name}>{intfc && intfc.name}</div>
          </div>
          <div className='topo-capacity-single'>
            通信参数
          </div>
          {this.getIntfcPropertyContent(capacity.id,intfc.id,intfcProperty)}
        </div>
      </Panel>);
    });
    return content;
  }


  getIntfcPropertyContent = (capacityId,intfcId,intfcProperty) => {
    let content = [];
    let interfaceProperty = this.interfaceProperty;
    intfcProperty && intfcProperty.map(item => {
      let intfcKey = `cpbl_intfc_${capacityId}_${intfcId}_${item.id}`;
      let value = interfaceProperty[intfcKey];
      if (value === undefined) {
        value = item.value;
      }
      interfaceProperty[intfcKey] = value;
      // updateInterfacePropertyCell(intfcKey,value);
      content.push(<div key={item.id} className='capacity-config-common'>
        <div className='property-key-style' title={item.displayName}>
          {item.displayName}：
        </div>
        <div style={{ width: '126px','float': 'left' }}>
          <Editable
            value={value}
            onChange={(e) => this.onInterfaceAttributeChange(intfcKey, e)}
            showOkCancel={false}
            placeholder={'请输入'}
          />
        </div>
      </div>);
    });
    return content;
  }

  render() {
    let { collapseKey } = this.state;
    return (
      <div className='topo-config-capacity-root'>
        <Collapse activeKey={collapseKey}  onChange={key => this.onChangeCollapseSize(key)} >
          {this.getCapaityContent()}
        </Collapse>
      </div>
    );
  }
}

DeviceCapacityInfoConfig.propTypes = {
  getImgPath: PropTypes.func,
  currentDeviceConfig: PropTypes.object,
  subviewId: PropTypes.string,
  nodeId: PropTypes.string,
  equipmentId: PropTypes.number,
  config: PropTypes.object,
  showProperty: PropTypes.func
};

export default DeviceCapacityInfoConfig;
