import React, { Component } from 'react';
import PropTypes from 'prop-types';
import GeneralEleContainer from './GeneralEleContainer';

class NodeLibList extends Component {

  static propTypes = {
    nodelList: PropTypes.array,
    mode: PropTypes.string
  };

  static defaultProps = {
    nodelList: []
  };

  render() {
    const { mode, nodelList } = this.props;
    return (
      <div className="nodelib-list">
        {
          nodelList.map(ml => <GeneralEleContainer key={ml.key} nodeLib={ml} mode={mode} />)
        }
      </div>
    );
  }
}

export default NodeLibList;
