import React, { Component } from 'react';
import PropTypes from 'prop-types';
import { OltSerUrl } from './../../../../consts/urlConsts';
import { Modal,Upload } from 'amos-antd';
import { message } from 'amos-framework';
import Icon from 'amos-icon';
import { editOrgImgAction,fetchOrgImgsAction } from './../../../../services/topoService';

const HEXSIZE = 1024;
/**
 * 上传图片
 *
 * @class UploadMultiPicModal
 * @extends {Component}
 */
class UploadMultiPicModal extends Component {
  constructor(props) {
    super(props);
    this.state = {
      visible: false,
      previewVisible: false,
      previewImage: '',
      imgFiles: []
    };
  }

  componentWillMount(){

  }

  componentDidMount(){
    this.fetchImgData(this.props.currentNode.key);
  }

  componentWillReceiveProps(nextProps){
    if (this.props.currentNode.key !== nextProps.currentNode.key) {
      this.fetchImgData(nextProps.currentNode.key);
    }
  }

  /**
   * 打开编辑对话框
   */
  onClick = () => {
    this.setState({ visible: true });
  }

  fetchImgData = (orgCode) => {
    orgCode && fetchOrgImgsAction(orgCode).then(data => {
      this.setState({ imgFiles: data.imgFiles });
    });
  }

  /**
   * 关闭编辑对话框
   */
  handCancel = () => {
    this.setState({ visible: false });
  }

  handSubmit = () => {
    let imgFiles = this.state.imgFiles;
    let orgCode = this.props.currentNode.key;
    let param = {
      imgFiles,
      orgCode
    };
    editOrgImgAction(param).then(data => {
      message.success('操作成功');
      this.setState({ visible: false });
    });
  }

  uploadCompanyPics = () => {
    this.setState({ visible: true });
  }

  handleCancel = () => this.setState({ previewVisible: false })

  handlePreview = (file) => {
    this.setState({
      previewImage: file.url || file.thumbUrl,
      previewVisible: true
    });
  }

  handleChange = ({ fileList }) => {
    this.setState({ imgFiles: fileList });
  }

  /**
   *
   *图片校验
   * @memberof UpLoadImg
   */
  beforeUpload = (file) => {
    var pattern = /image\/(gif|jpeg|png|jpg|bmp)$/;
    const isImg = pattern.test(file.type);
    if (!isImg) {
      message.danger('请选择符合格式的图片！（gif|jpeg|png|jpg|bmp）');
    }
    const isLt2M = file.size / HEXSIZE / HEXSIZE < 4;
    if (!isLt2M) {
      message.danger('图片最大为 4MB!');
    }
    return isImg && isLt2M;
  };

  render() {
    const { previewVisible, previewImage, imgFiles } = this.state;
    let { maxImg } = this.props;
    const uploadButton = (
      <div>
        <Icon type="plus" />
        <div className="ant-upload-text">添加图片</div>
      </div>
    );
    const url = OltSerUrl.addDevice;
    return (
      <div className='upload-img-root'>
        <div className="upload-img-icon" onClick={this.uploadCompanyPics} title="上传图片">
          <Icon icon="file-upload" />
        </div>
        <Modal maskClosable={false} title='上传图片' closable visible={this.state.visible} onCancel={this.handCancel} onOk={this.handSubmit} width={367}>
          <div className="upload-pics-content">
            <Upload
              action={url}
              listType="picture-card"
              fileList={imgFiles}
              onPreview={this.handlePreview}
              onChange={this.handleChange}
              beforeUpload={this.beforeUpload}
            >
            {imgFiles.length >= maxImg ? null : uploadButton}
            </Upload>
            <Modal visible={previewVisible} footer={null} onCancel={this.handleCancel}>
              <img alt="example" style={{ width: '100%' }} src={previewImage} />
            </Modal>
          </div>
        </Modal>
      </div>
    );
  }
}

UploadMultiPicModal.propTypes = {
  currentNode: PropTypes.object,
  maxImg: PropTypes.number
};

export default UploadMultiPicModal;
