import React, { Component } from 'react';
import PropTypes from 'prop-types';
import GridButton from './../../common/btns/GridButton';
import SimpleModal from './../../common/modal/SimpleModal';
import UserAddEdit from './UserAddEdit';
import {objOfStrPropTrim} from './../../common/utils/validate';
import {Form} from 'amos-antd';
const createForm = Form.create();
/**
 * 新增用户
 * @class AddUser
 * @extends {Component}
 */
class AddUser extends Component {
  constructor(props) {
    super(props);
    this.state = {
      visible: false,
      handleReset: () => {}
    };
  }
  /**
   * 打开新增用户对话框
   */
  onClick = () => {
    this.setState({visible: true});
  }

  handleSave = (obj) => {
    this.props.userAddAction(obj);this.handCancel();
  }

  setHandleReset = (handleReset) => {
    this.setState({handleReset: handleReset})
  }

  /**
   * 关闭新增用户对话框
   */
  handCancel = () => {
    this.props.form.resetFields();
    this.setState({visible: false});
    this.state.handleReset();
  }
  /**
   * 保存按钮事件
   */
  handleSubmit = (e) => {
    e.preventDefault();
    this.props.form.validateFields((errors, values) => {
      if(errors) {
        return;
      }
      values.enabled =  values.enabled === 'enable';
      values = objOfStrPropTrim(values);
      this.handleSave(values);
      this.props.form.resetFields();
    });
  }

  render() {
    let {text,form} = this.props;
    let isEdit = true;
    return (
      <span>
        <GridButton text={text} color='#FFF'  icon='plus' onClick={this.onClick} />
        <SimpleModal title='新增用户' visible={this.state.visible} onOk={this.handleSubmit} onCancel={this.handCancel}  width={685} >
          <UserAddEdit  submit={this.handleSubmit} isEdit={isEdit} parentform={form}  {...this.props} setHandleReset={this.setHandleReset}/>
        </SimpleModal>
      </span>
    );
  }
}

AddUser.propTypes = {
  text: PropTypes.string,
  reload: PropTypes.func,
  userAddAction: PropTypes.func,
  form: PropTypes.any
};

AddUser.defaultProps = {
};
export default createForm(AddUser);
