import React, { Component } from 'react';
import PropTypes from 'prop-types';
import {AmosValidate} from './../../common/utils/processor';
// import './../common/formStyle.scss';
// import './style/index.scss';
import {Form,Input,Row,Col} from 'amos-antd';
const FormItem = Form.Item;

const dataToTree = (dataList = []) => {
  dataList.map((data)=>{
    data.label = data.text;
    data.key = data.id;
    data.value = data.id;
    if(data.children){
      dataToTree(data.children);
    }
  });
};

/**
 * 用户编辑和新建内容
 * @class EditPassword
 * @extends {Component}
 */
class EditPassword extends Component {
  constructor(props) {
    super(props);
    this.state = {

    };
  }

  /**
   * 校验原密码
   */
  checkPassword = (rule, value, callback) => {
    const {getFieldValue} = this.props.parentform;
    if(!getFieldValue('originalPassword')){
      callback('请先输入原始密码！');
    } else {
      if(value) {
        if(!AmosValidate.isPassword(value)){
          callback('请输入正确的密码格式！');
        } else {
          if(value === getFieldValue('originalPassword')){
            callback('新密码和原始密码不能相同！');
          } else {
            callback();
          }
        }
      } else {
        callback();
      }
    }
  }


 /**
   * 校验重复密码
   */
  checkRePassword = (rule, value, callback) => {
    const {getFieldValue} = this.props.parentform;
    if(value && value !== getFieldValue('newPassword')) {
      callback('两次输入密码不一致！');
    } else {
      callback();
    }
  }

  render() {
    const {parentform,submit} = this.props;
    const {getFieldProps} = parentform;
    const originalPasswordProps = getFieldProps('originalPassword', {
      rules: [
         {required: true,  message: '请输入原密码'},
         {validator: this.checkOriginalPassword}
      ]
    });
    const newPasswordProps = getFieldProps('newPassword', {
      rules: [
         {required: true,  message: '请输入新密码'},
         {validator: this.checkPassword}
      ]
    });
    const rePasswordProps = getFieldProps('newConfirmPassword', {
      rules: [
        {required: true,  message: '请输入确认密码'},
        {validator: this.checkRePassword}
      ]
    });
    const formItemLayout = {
      labelCol: {span: 7},
      wrapperCol: {span: 16}
    };
    return (
      <div className='user-add-edit amos-grid-from'>
        <Form inline onSubmit={submit}>
          <Row>
            <Col span={12}>
              <FormItem label='原始密码'  {...formItemLayout}>
                <Input className='amos-grid-form-input' type='password' {...originalPasswordProps} style={{width: 240}} />
              </FormItem>
            </Col>
          </Row>
          <Row>
            <Col span={12}>
              <FormItem label='新密码'  {...formItemLayout}>
                <Input className='amos-grid-form-input' type='password' {...newPasswordProps} style={{width: 240}} />
              </FormItem>
            </Col>
          </Row>
          <Row>
            <Col span={12}>
              <FormItem label='确认密码'  {...formItemLayout}>
                <Input className='amos-grid-form-input' {...rePasswordProps} type='password' style={{width: 240}} />
              </FormItem>
            </Col>
          </Row>
        </Form>
      </div>
    );
  }
}

EditPassword.propTypes = {
  user: PropTypes.object,//用户信息对象
  submit: PropTypes.func,//保存事件回调
  cancel: PropTypes.func,//取消事件回调
  parentform: PropTypes.any
};

EditPassword.defaultProps = {

};

export default EditPassword;
