import React, { Component } from 'react';
import PropTypes from 'prop-types';
import GridButton from './../../common/btns/GridButton';
import {Modal} from 'amos-antd';

/**
 * 启用用户信息
 * @class StartUser
 * @extends {Component}
 */
class StartUser extends Component {
  constructor(props) {
    super(props);
  }

  onClick=() => {
    const {selectRows} = this.props;
    let startfunc = this.handleStart;
    if(selectRows.length == 0) {
      Modal.warning({
        title: '系统提示',
        content: '请先选中要启用的信息。',
        okText: '确定'
      });
      return null;
    } else {
      if(selectRows[0].userName === 'admin' && selectRows[0].role.name === 'admin'){
        Modal.warning({
          title: '提示',
          content: '不能操作管理员用户'
        });
      } else {
        Modal.confirm({
          title: '批量启用',
          content: '是否启用所选信息？',
          okText: '确定',
          cancelText: '取消',
          onOk() {startfunc();},
          onCancel() {}
        });
        return null;
      }
    }
  }

  handleStart = () => {
    let {selectRows} = this.props;
    let ids = [];
    selectRows .map((e)=>{
      ids.push(e.id);
    });
    this.props.userEnableAction(ids);
  }


  render() {
    const {text} = this.props;
    return (
      <span>
        <GridButton text={text} onClick={this.onClick} icon="unlock" />
      </span>
    );
  }
}

StartUser.propTypes = {
  text: PropTypes.string,//批量启用按钮名称
  selectRows: PropTypes.array,//批量启用的数据ID
  url: PropTypes.string,//批量启用的数据的URL
  reload: PropTypes.func,
  userEnableAction: PropTypes.func
};

StartUser.defaultProps = {
  text: '启用',
  selectRows: []
};

export default StartUser;
