import { bindActionCreators } from 'redux';
import { connect } from 'react-redux';
// import userAction from './../../model/user';

const mapState2Props = (state) => {
  let userState = state.userReducer;
  let userInfo = userState.getIn([ 'SEC_USER','userInfo' ]);
  let departmentTreeData = userState.getIn([ 'SEC_USER','departmentTreeData' ]);
  let allRole = userState.getIn([ 'SEC_USER','allRole' ]);
  let needRefreshTable = userState.getIn([ 'SEC_USER','needRefreshTable' ]);
  let tableList = userState.getIn([ 'SEC_USER','tableList' ]) || {};
  let superiorCompanyList = userState.getIn([ 'SEC_USER','superiorCompanyList' ]) || {};
  let totals = tableList.totals;
  let dataList = tableList.dataList;
  return {
    userInfo,
    departmentTreeData,
    allRole,
    totals,
    dataList,
    superiorCompanyList,
    needRefreshTable
  };
};

const actionCreators = (actions,bindActionCreators,dispatch) => {
  let keys = Object.keys(actions);
  keys.map(actionKey=>actions[actionKey] = bindActionCreators(actions[actionKey], dispatch));
  return actions;
};

const mapDispatch2Props = (dispatch,actions) => {
  return actionCreators(actions,bindActionCreators,dispatch);
};

const userConnect = (base) => {
  return (ComposedComponent)=>connect(mapState2Props, (dispatch)=>mapDispatch2Props(dispatch,userAction(base)))(ComposedComponent);
};

export default userConnect;
