import React, { Component } from 'react';
import { Card, Button } from 'amos-antd';
import { Scrollbars } from 'amos-framework';
import TubeEquipNum from './statistics/TubeEquipNum';
import Task from './statistics/Task';
import AccountInfo from './statistics/AccountInfo';
import Alarm from './statistics/Alarm';
import EquipInterface from './statistics/EquipInterface';
import EquipProtocol from './statistics/EquipProtocol';
import PrototypeEquip from './statistics/PrototypeEquip';
import { analysis } from '../../../consts/outterUrlConsts';

import './index.scss';

/**
 * 总览
 *
 * @class Overview
 * @extends {Component}
 */
class Overview extends Component {
  constructor(props) {
    super(props);

  }

  render() {
    return (
      <Scrollbars>
        <div className="overview-container" style={{ width: '100%', height: '100%' }}>
          <div className="overview-left">
            <div className="overview-item overview-tubeequipnum">
              <Card title="纳管设备数量统计">
                <TubeEquipNum />
              </Card>
            </div>
            <div className="overview-item overview-task">
              <Card title="任务统计">
                <Task />
              </Card>
            </div>
          </div>
          <div className="overview-right">
            {/*<div className="overview-item overview-accountinfo">
              <Card title="账户信息">
                <AccountInfo />
              </Card>
            </div>
            <div className="overview-item">
              <Card title="我的应用">
                <Button type='primary' onClick={() => analysis()} >
                  <a  type='primary'  href={analysis()} target="_blank">大数据分析</a>
                </Button>
              </Card>
            </div>*/}
            <div className="overview-item overview-alarm">
              <Card title="告警统计">
                <Alarm />
              </Card>
            </div>
            <div className="overview-item overview-equipinterface">
              <Card title={<span>通信方式统计</span>}>
                <EquipInterface />
              </Card>
            </div>
            <div className="overview-item overview-equipprotocol">
              <Card title={<span>通信协议统计</span>}>
                <EquipProtocol />
              </Card>
            </div>
            <div className="overview-item overview-prototypeequip">
              <Card title="原型设备统计">
                <PrototypeEquip />
              </Card>
            </div>
          </div>
        </div>
      </Scrollbars>
    );
  }
}

export default Overview;
