import React, { Component } from 'react';
import PropTypes from 'prop-types';
import { PieCharts } from 'amos-viz/lib/echarts';
import { browserHistory } from 'amos-react-router';
import { AmosFetch } from '../../../../utils/processor';
import OltSerUrl from '../../../../consts/urlConsts';
import { PubSub } from 'ray-eventpool';
import { STATICTICS_JUMP_TOPIC } from './modelConf/nodeConf';

import {
  option
} from './chartData/PrototypeEquipData';
/**
 * 原型设备统计
 *
 * @class PrototypeEquip
 * @extends {Component}
 */
class PrototypeEquip extends Component {
  constructor(props) {
    super(props);
    this.state = {
      count: 0,
      pubCount: 0,
      priCount: 0
    };
  }

  componentWillMount(){
    let url = `${OltSerUrl.getDeviceCount}`;
      //获取接口通讯方式
    AmosFetch.get(url).then(res => {
      if (res.ok) {
        return res.json();
      }
      else
        {
        throw new Error('从服务端获取数据失败！');
      }
    }).then((data)=>{
      if (data.result === 'SUCCESS'){
        this.setState({ count: data.dataList.count,pubCount: data.dataList.pubCount,priCount: data.dataList.priCount });
      }
    });
  }
  eConsole = (param) => {
    //alert(option.series[0].data.length);
    //alert(option.series[0].data[i]);
    //param.dataIndex 获取当前点击索引，
    //alert(param.dataIndex);
    let dataIndex = param.dataIndex;
    this.jumpTrigger();
    if (dataIndex === 0){
      browserHistory.push('/main/monitor/deviceCustom/deviceManage');
    } else if (dataIndex === 2) {
      browserHistory.push(`/main/monitor/deviceCustom/deviceManage?activeKey=2`);
    }
  }

  jumpTrigger = () => {
    PubSub.publish(STATICTICS_JUMP_TOPIC.trigger, {
      childkey: '12',
      parentKey: '9'
    });
  }

  render() {
    let { count,pubCount,priCount } = this.state;
    let array = [];
    let param = {
      type: 'click',
      handler: this.eConsole
    };
    array.push(param);
    return (
      <div className="overview-item-chart">
        <div className="overview-prototypeequip-chart">
          <PieCharts
            pieOps={option(pubCount,priCount)}
            chartStyle={{ width: '100%', height: '82px' }}
            eventpool={array}
          />
        </div>
        <div className="overview-prototypeequip-item title">
          <p className="value">{count}</p>
          <p className="">总数</p>
        </div>
        <div className="overview-prototypeequip-item first">
          <p className="value" onClick={(e) => this.eConsole({ dataIndex: 0 },e)}>{pubCount}</p>
          <p className=""><span />公开设备</p>
        </div>
        <div className="overview-prototypeequip-item second">
          <p className="value" onClick={(e) => this.eConsole({ dataIndex: 2 },e)}>{priCount}</p>
          <p className=""><span />私有设备</p>
        </div>
      </div>
    );
  }
}

export default PrototypeEquip;
