let scaleData = [
  {
    'name': '公开设备协议',
    'value': 2164,
    'color': '#0099cc'
  },
  {
    'name': '私有设备协议',
    'value': 3184,
    'color': '#ff9900'
  }
];

let rich = {
  white: {
    color: 'black',
    align: 'center',
    padding: [5, 0]
  }
};

var placeHolderStyle = {
  normal: {
    label: {
        show: false
    },
    labelLine: {
        show: false
    },
    color: 'rgba(0, 0, 0, 0)',
    borderColor: 'rgba(0, 0, 0, 0)',
    borderWidth: 0
  }
};
let data = [];

for (let i = 0; i < scaleData.length; i++) {
  data.push({
    value: scaleData[i].value,
    name: scaleData[i].name,
    itemStyle: {
      normal: {
        borderWidth: 4,
        shadowBlur: 10,
        color: 'black',
        borderColor: scaleData[i].color,
        shadowColor: 'rgba(142, 152, 241, 0.6)'
      }
    }
  }, {
    value: 100,
    name: '',
    itemStyle: placeHolderStyle
  });
}

let seriesObj = [{
  name: '',
  type: 'pie',
  clockWise: false,
  radius: [33, 36],
  hoverAnimation: false,
  itemStyle: {
    normal: {
        label: {
            show: false
        },
        labelLine: {
            show: false
        }
    }
  },
  data: data
}];

export const option = {
  // backgroundColor: '#04243E',
  tooltip: {
    show: false
  },
  legend: {
    show: false
  },
  toolbox: {
    show: false
  },
  series: seriesObj
};
