/* eslint object-shorthand: 0 */
/* eslint prefer-template: 0 */

/**
 * webpack 打包配置文件
 * @author ilex
 */

const { tools } = require('ray-plugins');
const simpleConfig = require('amos-build/lib/simpleConfig');

const __ENV__ = tools.trim(process.env.NODE_ENV);
// ------------------------------------------------------
// 添加webpack加载别名,用于导包重定向，优化打包以及代码
// 此处需要自己进行定义
// 👻可修改
// ------------------------------------------------------
const alias = {
  MODEL: __dirname + '/src/model',
  UTILS: __dirname + '/src/utils',
  CONSTS: __dirname + '/src/consts',
  _MOCK: __dirname + '/src/_mock'
};

// ------------------------------------
// 入口点
// ------------------------------------
// 发布模式入口
const prodEntry = {
  // app: './demo/index.js'
  // app: './src/entry/demo.js'
  app: './src/entry/index.prod.js'
};

// 开发模式入口
const devEntry = {
  // app: './demo/index.js'
  // app: './src/entry/demo.js'
  // code split 测试
  // app: './src/entry/index.prod.js'
  app: './src/entry/index.js'
};

const config = {
  tpl: './tpl.html',
  toFile: 'index.html',
  entry: __ENV__ === 'production' ? prodEntry : devEntry,
  useHot: true,
  lint: false,
  port: 3300,
  alias: alias,
  sourceMap: __ENV__ === 'production' ? false : true
};

const defaultConfig = simpleConfig(config);

defaultConfig.name = 'amos-iot';


if (__ENV__ === 'development'){
  // 开发模式下，配置 proxy，跳过跨域问题
  defaultConfig.devServer.proxy = {
    '/baseURI': {
      // target: 'http://172.16.10.70:10005/',
      target: 'http://172.16.3.3:10005/',
      pathRewrite: { '^/baseURI': '' }
    }
  };
}


module.exports = defaultConfig;
