package com.yeejoin.amos.boot.module.common.api.dto;

import java.io.Serializable;

import com.alibaba.excel.annotation.ExcelIgnore;
import com.alibaba.excel.annotation.ExcelProperty;
import com.yeejoin.amos.boot.module.common.api.excel.ExplicitConstraint;
import com.yeejoin.amos.boot.module.common.api.excel.CommonExplicitConstraint;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

@Data
@ApiModel(value = "KeySite", description = "重点部位")
public class KeySiteExcleDto implements Serializable {

	/**
	* 
	*/
	@ExcelIgnore
	private static final long serialVersionUID = 1L;
	@ApiModelProperty(value = "序号")
	@ExcelIgnore
	private Integer number;

	@ExcelProperty(value = "重点部位名称", index = 0)
	@ApiModelProperty(value = "重点部位名称")
	private String name;

	@ExcelProperty(value = "所属单位/部门id", index = 1)
	@ExplicitConstraint(indexNum = 1,  sourceClass = CommonExplicitConstraint.class, method = "getCompanyDetailTree") //固定下拉内容
	@ApiModelProperty(value = "所属单位/部门id")
	private String belongName;

	@ExcelIgnore
	private Long belongId;
    
	@ExcelProperty(value = "所属建筑id", index = 2)
	@ExplicitConstraint(indexNum = 2,  sourceClass = CommonExplicitConstraint.class, method = "getBuildTree") //固定下拉内容
	@ApiModelProperty(value = "所属建筑id")
	private String buildingName;
	
	@ExcelIgnore
	private Long buildingId;

	@ExcelProperty(value = "位置描述", index = 3)
	@ApiModelProperty(value = "位置描述")
	private String addressDesc;

	@ExcelProperty(value = "建筑面积(㎡)", index = 4)
	@ApiModelProperty(value = "建筑面积(㎡)")
	private String buildingArea;
	
	@ExcelIgnore
	@ApiModelProperty(value = "建筑高度(m)")
	private String buildingHeight;
	@ExplicitConstraint(type = "NHDJ", indexNum =5, sourceClass = CommonExplicitConstraint.class) //动态下拉内容
	@ExcelProperty(value = "耐火等级", index = 5)
	@ApiModelProperty(value = "耐火等级")
	private String fireEnduranceRate;
	
	@ExplicitConstraint(type = "JZWSYXZ", indexNum =6, sourceClass = CommonExplicitConstraint.class) //动态下拉内容
	@ExcelProperty(value = "使用性质", index = 6)
	@ApiModelProperty(value = "使用性质")
	private String useNature;
 
	@ExcelProperty(value = "责任人", index = 7)
	@ApiModelProperty(value = "责任人")
	private String chargePerson;
   
	@ExcelProperty(value = "责任人身份证", index = 8)
	@ApiModelProperty(value = "责任人身份证")
	private String chargePersonId;

	@ExcelProperty(value = "确定重点防火部位的原因", index = 9)
	@ApiModelProperty(value = "确定重点防火部位的原因")
	private String keyPreventionReason;
   
	@ExcelProperty(value = "消防设施情况", index = 10)
	@ExplicitConstraint(indexNum=11,source = {"有","无"})
	@ApiModelProperty(value = "消防设施情况")
	private String fireFacilitiesInfo;
 
	@ExcelProperty(value = "防火标志设立情况", index = 11)
	@ApiModelProperty(value = "防火标志设立情况")
	private String firePreventionFlagName;

	@ExcelProperty(value = "危险源", index = 12)
	@ApiModelProperty(value = "危险源")
	private String hazard;

	@ExcelProperty(value = "消防安全管理措施", index = 13)
	@ApiModelProperty(value = "消防安全管理措施")
	private String safetyManagementMeasures;
 
	@ExcelProperty(value = "防范手段措施", index = 14)
	@ApiModelProperty(value = "防范手段措施")
	private String preventiveMeasures;

	@ExcelProperty(value = "备注", index = 15)
	@ApiModelProperty(value = "备注")
	private String remark;
}
