package com.yeejoin.amos.boot.module.jcs.biz.controller;

import com.yeejoin.amos.boot.biz.common.controller.BaseController;
import com.yeejoin.amos.boot.module.jcs.api.dto.ControllerEquipDto;
import com.yeejoin.amos.boot.module.jcs.api.entity.ControllerEquip;
import com.yeejoin.amos.boot.module.jcs.biz.service.impl.ControllerEquipServiceImpl;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.typroject.tyboot.core.foundation.enumeration.UserType;
import org.typroject.tyboot.core.restful.doc.TycloudOperation;
import org.typroject.tyboot.core.restful.utils.ResponseHelper;
import org.typroject.tyboot.core.restful.utils.ResponseModel;

import java.util.List;

/**
 * 控制器设备
 *
 * @author system_generator
 * @date 2021-12-03
 */
@RestController
@Api(tags = "Api")
@RequestMapping(value = "/controller-equip")
public class ControllerEquipController extends BaseController {
    @Autowired
    ControllerEquipServiceImpl controllerEquipServiceImpl;

    /**
     * 列表全部数据查询
     *
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(httpMethod = "GET", value = "列表全部数据查询", notes = "列表全部数据查询")
    @GetMapping(value = "/list")
    public ResponseModel<List<ControllerEquip>> selectForList() {
        return ResponseHelper.buildResponse(controllerEquipServiceImpl.list());
    }
}
