package com.yeejoin.amos.maintenance.business.controller;

import com.yeejoin.amos.maintenance.business.service.intfc.ISynDataService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.typroject.tyboot.core.foundation.enumeration.UserType;
import org.typroject.tyboot.core.restful.doc.TycloudOperation;
import org.typroject.tyboot.core.restful.utils.ResponseHelper;
import org.typroject.tyboot.core.restful.utils.ResponseModel;


@RestController
@RequestMapping(value = "/api/syn")
@Api(tags = "维保同步接口api")
@Slf4j
public class SynDataController extends AbstractBaseController {


    @Autowired
    private ISynDataService iSynDataService;

    /**
     * 同步巡检项
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(value = "同步删除维保点", notes = "同步删除维保点")
    @DeleteMapping(value = "/{ids}/point")
    public ResponseModel pointDelete(@PathVariable String ids) {
        return ResponseHelper.buildResponse(iSynDataService.pointDelete(ids));
    }
}
