package com.yeejoin.amos.boot.module.jg.biz.controller;

import org.springframework.web.bind.annotation.RequestMapping;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.Api;
import org.springframework.web.bind.annotation.RestController;
import com.yeejoin.amos.boot.biz.common.controller.BaseController;
import java.util.List;
import com.yeejoin.amos.boot.module.jg.biz.service.impl.JgVehicleInformationEqServiceImpl;
import org.typroject.tyboot.core.restful.utils.ResponseHelper;
import org.typroject.tyboot.core.restful.utils.ResponseModel;
import org.springframework.beans.factory.annotation.Autowired;
import javax.servlet.http.HttpServletRequest;
import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yeejoin.amos.boot.module.jg.api.dto.JgVehicleInformationEqDto;
import org.typroject.tyboot.core.restful.doc.TycloudOperation;
import org.typroject.tyboot.core.foundation.enumeration.UserType;

/**
 * 
 *
 * @author system_generator
 * @date 2024-03-18
 */
@RestController
@Api(tags = "车用气瓶控制类Api")
@RequestMapping(value = "/jg-vehicle-information-eq")
public class JgVehicleInformationEqController extends BaseController {

    @Autowired
    JgVehicleInformationEqServiceImpl jgVehicleInformationEqServiceImpl;

    /**
     * 新增车用气瓶控制类
     *
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
	@PostMapping(value = "/save")
	@ApiOperation(httpMethod = "POST", value = "新增车用气瓶控制类", notes = "新增车用气瓶控制类")
	public ResponseModel<JgVehicleInformationEqDto> save(@RequestBody JgVehicleInformationEqDto model) {
	    model = jgVehicleInformationEqServiceImpl.createWithModel(model);
	    return ResponseHelper.buildResponse(model);
	}

	/**
     * 根据sequenceNbr更新
     *
     * @param sequenceNbr 主键
     * @return
     */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@PutMapping(value = "/{sequenceNbr}")
	@ApiOperation(httpMethod = "PUT", value = "根据sequenceNbr更新车用气瓶控制类", notes = "根据sequenceNbr更新车用气瓶控制类")
	public ResponseModel<JgVehicleInformationEqDto> updateBySequenceNbrJgVehicleInformationEq(@RequestBody JgVehicleInformationEqDto model, @PathVariable(value = "sequenceNbr") Long sequenceNbr) {
	    model.setSequenceNbr(sequenceNbr);
	    return ResponseHelper.buildResponse(jgVehicleInformationEqServiceImpl.updateWithModel(model));
	}

	/**
     * 根据sequenceNbr删除
     *
     * @param sequenceNbr 主键
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @DeleteMapping(value = "/{sequenceNbr}")
    @ApiOperation(httpMethod = "DELETE", value = "根据sequenceNbr删除车用气瓶控制类", notes = "根据sequenceNbr删除车用气瓶控制类")
    public ResponseModel<Boolean> deleteBySequenceNbr(HttpServletRequest request, @PathVariable(value = "sequenceNbr") Long sequenceNbr){
        return ResponseHelper.buildResponse(jgVehicleInformationEqServiceImpl.removeById(sequenceNbr));
    }

    /**
     * 根据sequenceNbr查询
     *
	 * @param sequenceNbr  主键
     * @return
     */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@GetMapping(value = "/{sequenceNbr}")
	@ApiOperation(httpMethod = "GET",value = "根据sequenceNbr查询单个车用气瓶控制类",  notes = "根据sequenceNbr查询单个车用气瓶控制类")
	public ResponseModel<JgVehicleInformationEqDto> selectOne(@PathVariable Long sequenceNbr) {
	    return ResponseHelper.buildResponse(jgVehicleInformationEqServiceImpl.queryBySeq(sequenceNbr));
	}

	/**
     * 列表分页查询
     *
     * @param current 当前页
     * @param current 每页大小
     * @return
     */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@GetMapping(value = "/page")
	@ApiOperation(httpMethod = "GET",value = "分页查询车用气瓶控制类",  notes = "分页查询车用气瓶控制类")
	public ResponseModel<Page<JgVehicleInformationEqDto>> queryForPage(@RequestParam(value = "current") int current, @RequestParam
                    (value = "size") int size) {
	    Page<JgVehicleInformationEqDto> page = new Page<JgVehicleInformationEqDto>();
	    page.setCurrent(current);
	    page.setSize(size);
	    return ResponseHelper.buildResponse(jgVehicleInformationEqServiceImpl.queryForJgVehicleInformationEqPage(page));
	}

	/**
	 * 列表全部数据查询
     *
	 * @return
	 */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@ApiOperation(httpMethod = "GET",value = "列表全部数据查询车用气瓶控制类",   notes = "列表全部数据查询车用气瓶控制类")
	@GetMapping(value = "/list")
	public ResponseModel<List<JgVehicleInformationEqDto>> selectForList() {
	    return ResponseHelper.buildResponse(jgVehicleInformationEqServiceImpl.queryForJgVehicleInformationEqList());
	}
}
