package com.yeejoin.amos.patrol.business.controller;

import com.yeejoin.amos.patrol.business.service.intfc.IMeasuresService;
import com.yeejoin.amos.patrol.business.util.CommonResponse;
import com.yeejoin.amos.patrol.business.util.CommonResponseUtil;
import com.yeejoin.amos.patrol.dao.entity.Measure;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;
import org.typroject.tyboot.core.foundation.enumeration.UserType;
import org.typroject.tyboot.core.restful.doc.TycloudOperation;

import java.util.Date;

@RestController
@RequestMapping(value = "/measures")
@Api(tags="风险管控措施api")
public class MeasuresController extends AbstractBaseController {
	
	@Autowired
	IMeasuresService measuresService;
	
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@PostMapping(value = "add", produces = "application/json;charset=UTF-8")
	@ApiOperation(value = "新增风险措施", notes = "新增风险措施")
	public CommonResponse measuresAdd(@ApiParam(value = "风险措施参数", required = false) @RequestBody(required = false) Measure measure) {
		try {
			Measure newMeasure = measuresService.saveMeasures(measure);
		} catch (Exception e) {
			return CommonResponseUtil.failure(e.getMessage());
		}
		return CommonResponseUtil.success();
	}
	
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@PostMapping(value = "update", produces = "application/json;charset=UTF-8")
	@ApiOperation(value = "修改风险措施", notes = "修改风险措施")
	public CommonResponse measuresUpdate(@ApiParam(value = "风险措施参数", required = false) @RequestBody(required = false) Measure measure) {
		try {
			measure.setUpdateBy(getUserId());;
			measure.setUpdateTime(new Date());
			Measure newMeasure = measuresService.saveMeasures(measure);
		} catch (Exception e) {
			return CommonResponseUtil.failure(e.getMessage());
		}
		return CommonResponseUtil.success();
	}
	
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@PostMapping(value = "delete/{id}", produces = "application/json;charset=UTF-8")
	@ApiOperation(value = "删除风险措施", notes = "删除风险措施")
	public CommonResponse measuresDelete(@ApiParam(value = "风险措施id", required = false) @PathVariable(required = true) Long id) {
		try {
			Measure curMeasure = measuresService.findById(id);
			curMeasure.setUpdateBy(getUserId());;
			curMeasure.setUpdateTime(new Date());
			curMeasure.setIsDel(1);
			Measure newMeasure = measuresService.saveMeasures(curMeasure);
		} catch (Exception e) {
			return CommonResponseUtil.failure(e.getMessage());
		}
		return CommonResponseUtil.success();
	}
	
}
