package com.yeejoin.amos.boot.module.elevator.flc.biz.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yeejoin.amos.boot.biz.common.utils.DateUtils;
import com.yeejoin.amos.boot.module.elevator.flc.api.dto.TaskDto;
import com.yeejoin.amos.boot.module.elevator.flc.api.entity.Task;
import com.yeejoin.amos.boot.module.elevator.flc.api.enums.TaskStatusEnum;
import com.yeejoin.amos.boot.module.elevator.flc.api.mapper.TaskMapper;
import com.yeejoin.amos.boot.module.elevator.flc.api.service.ITaskService;
import org.springframework.stereotype.Component;
import org.typroject.tyboot.core.foundation.utils.ValidationUtil;
import org.typroject.tyboot.core.rdbms.annotation.Condition;
import org.typroject.tyboot.core.rdbms.annotation.Operator;
import org.typroject.tyboot.core.rdbms.service.BaseService;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * 任务表服务实现类
 *
 * @author system_generator
 * @date 2022-05-31
 */
@Component
public class TaskServiceImpl extends BaseService<TaskDto, Task, TaskMapper> implements ITaskService {

    public void deleteById(Long sequenceNbr) {
        TaskDto taskDto = this.queryBySeq(sequenceNbr);
        taskDto.setIsDelete(true);
        this.updateWithModel(taskDto);
    }

    public Page<TaskDto> queryForTaskPageByParams(Page<TaskDto> page, String userId, String sendTimeStart, String sendTimeEnd, String taskType, String status, String content) {
        List<Integer> statusList = getStatus(status);
        if (!ValidationUtil.isEmpty(sendTimeStart) && !ValidationUtil.isEmpty(sendTimeEnd)){
            Date[] createDate = new Date[2];
            createDate[0] = DateUtils.getCurrentDayStartTime(DateUtils.longStr2Date(sendTimeStart));
            createDate[1] = DateUtils.getCurrentDayEndTime(DateUtils.longStr2Date(sendTimeEnd));
            return this.queryForTaskPageByCreateDate(page, userId, createDate, taskType, statusList, content);
        }
        return this.queryForTaskPage(page, userId, taskType,statusList, content);
    }

    public JSONObject queryCountForMap(String userId){
        Date[] recDate = new Date[2];
        Date now = DateUtils.getDateNow();
        recDate[0] = DateUtils.getCurrentDayStartTime(now);
        recDate[1] = DateUtils.getCurrentDayEndTime(now);

        // 我的待办
        Integer myTaskCount = this.queryForCount(userId, null, null);
        // 今日已办
        List<Integer> statusList = getStatus("complete");
        Integer todyCompletedTaskCount = this.queryForCount(userId, recDate, statusList);
        // 未完结业务
        Integer unCompletedTaskCount = this.queryForCount(userId, null, statusList);

        JSONObject jsonObject = new JSONObject();
        jsonObject.put("myTask", myTaskCount);
        jsonObject.put("todyCompletedTask", todyCompletedTaskCount);
        jsonObject.put("unCompletedTask", unCompletedTaskCount);
        return jsonObject;
    }

    /**
     * 分页查询
     */
    public Page<TaskDto> queryForTaskPage(Page<TaskDto> page, String userId, String taskType, @Condition(Operator.in) List<Integer> status, @Condition(Operator.like) String content) {
        return this.queryForPage(page, "rec_date", false, userId, taskType, status, content);

    }

    /**
     * 分页查询(含日期)
     */
    public Page<TaskDto> queryForTaskPageByCreateDate(Page<TaskDto> page, String userId, @Condition(Operator.between) Date[] createDate, String taskType, @Condition(Operator.in) List<Integer> status, @Condition(Operator.like) String content) {
        return this.queryForPage(page, "rec_date", false, userId, createDate, taskType, status, content);
    }

    /**
     * 列表查询 示例
     */
    public List<TaskDto> queryForTaskList() {
        return this.queryForList("", false);
    }

    /**
     * 列表查询 示例
     */
    public Integer queryForCount(String userId, @Condition(Operator.between) Date[] recDate, @Condition(Operator.in) List<Integer> status) {
        return this.queryCount(userId, recDate, status);
    }

    private List<Integer> getStatus (String status) {
        List<Integer> statusList = new ArrayList<>();
        if ("uncomplete".equals(status)) {
            statusList.add(TaskStatusEnum.待填报.getKey());
            statusList.add(TaskStatusEnum.待签收.getKey());
        } else if ("complete".equals(status)) {
            statusList.add(TaskStatusEnum.已完成.getKey());
        }
        return statusList;
    }
}