package com.yeejoin.amos.boot.module.cylinder.biz.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.yeejoin.amos.boot.module.cylinder.biz.utils.BeanDtoVoUtils;
import com.yeejoin.amos.boot.module.cylinder.api.dto.RescueStationDto;
import com.yeejoin.amos.boot.module.cylinder.api.entity.RescueStation;
import com.yeejoin.amos.boot.module.cylinder.api.mapper.RescueStationMapper;
import com.yeejoin.amos.boot.module.cylinder.api.service.IRescueStationService;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.typroject.tyboot.core.foundation.context.RequestContext;
import org.typroject.tyboot.core.foundation.utils.ValidationUtil;
import org.typroject.tyboot.core.rdbms.service.BaseService;

import java.util.Arrays;
import java.util.Date;
import java.util.List;

/**
*  服务实现类
*
* @author tb
* @date 2021-06-01
*/
@Service
public class RescueStationServiceImpl extends BaseService<RescueStationDto, RescueStation, RescueStationMapper> implements IRescueStationService {

    @Autowired
    RescueStationMapper rescueStationMapper;
    @Autowired
    IRescueStationService iRescueStationService;

    @Override
    public List<RescueStationDto> getListByLatLonDistance(String lat, String lon, Integer distance) {
        return rescueStationMapper.getListByLatLonDistance(lat,lon,distance);
    }

    @Override
    public List<RescueStationDto> selectExportData(String exportId) {
        List<String> ids = null;
        if(StringUtils.isNotEmpty(exportId)) {
            String[] idStr = exportId.split(",");
            ids = Arrays.asList(idStr);
        }
        return baseMapper.selectExportData(ids);
    }


    public Boolean saveRescueStation(RescueStationDto rescueStationDto){
        RescueStation rescueStation = BeanDtoVoUtils.convert(rescueStationDto, RescueStation.class);
        rescueStation.setRecUserId(RequestContext.getExeUserId());
        rescueStation.setRecDate(new Date());
        boolean save =false;
        LambdaQueryWrapper<RescueStation> wrapper = new LambdaQueryWrapper<>();
        if (!ValidationUtil.isEmpty(rescueStation)) {
            wrapper.eq(!ValidationUtil.isEmpty(rescueStation.getName()),RescueStation::getName,rescueStation.getName())
                    .eq(!ValidationUtil.isEmpty(rescueStation.getCity()),RescueStation::getCity,rescueStation.getCity())
                    .eq(!ValidationUtil.isEmpty(rescueStation.getDistrict()),RescueStation::getDistrict,rescueStation.getDistrict())
                    .eq(!ValidationUtil.isEmpty(rescueStation.getAffiliatedUnit()),RescueStation::getAffiliatedUnit,rescueStation.getAffiliatedUnit())
                    .eq(!ValidationUtil.isEmpty(rescueStation.getAddress()),RescueStation::getAddress,rescueStation.getAddress())
                    .eq(!ValidationUtil.isEmpty(rescueStation.getAffiliatedUnitId()),RescueStation::getAffiliatedUnitId,rescueStation.getAffiliatedUnitId())
                    .eq(!ValidationUtil.isEmpty(rescueStation.getLatitude()),RescueStation::getLatitude,rescueStation.getLatitude())
                    .eq(!ValidationUtil.isEmpty(rescueStation.getLongitude()),RescueStation::getLongitude,rescueStation.getLongitude())
                    .eq(!ValidationUtil.isEmpty(rescueStation.getPrincipal()),RescueStation::getPrincipal,rescueStation.getPrincipal())
                    .eq(!ValidationUtil.isEmpty(rescueStation.getPrincipalPhone()),RescueStation::getPrincipalPhone,rescueStation.getPrincipalPhone())
                    .eq(!ValidationUtil.isEmpty(rescueStation.getProvince()),RescueStation::getProvince,rescueStation.getProvince())
                    .eq(!ValidationUtil.isEmpty(rescueStation.getRegionCode()),RescueStation::getRegionCode,rescueStation.getRegionCode())
                    .eq(!ValidationUtil.isEmpty(rescueStation.getRescueLeader()),RescueStation::getRescueLeader,rescueStation.getRescueLeader())
                    .eq(!ValidationUtil.isEmpty(rescueStation.getRescueLeaderPhone()),RescueStation::getRescueLeaderPhone,rescueStation.getRescueLeaderPhone());
            List<RescueStation> rescueStations = rescueStationMapper.selectList(wrapper);
            if (ValidationUtil.isEmpty(rescueStations) ) {
                save = iRescueStationService.save(rescueStation);
            }

        }
        return save;
    }
}
