package com.yeejoin.amos.boot.module.jg.biz.service;


import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.yeejoin.amos.boot.biz.common.bo.CompanyBo;
import com.yeejoin.amos.boot.biz.common.bo.ReginParams;
import com.yeejoin.amos.boot.module.jg.api.dto.EquipmentClassifyDto;
import com.yeejoin.amos.boot.module.jg.api.dto.InstanceRuntimeData;
import com.yeejoin.amos.boot.module.jg.api.dto.UseFlagParamDto;
import com.yeejoin.amos.boot.module.jg.api.entity.JgUseRegistrationManage;
import com.yeejoin.amos.boot.module.ymt.api.dto.EquipmentCategoryDto;
import com.yeejoin.amos.boot.module.ymt.api.entity.EquipmentCategory;

import javax.servlet.http.HttpServletResponse;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

/**
 * 装备分类接口类
 *
 * @author system_generator
 * @date 2021-10-20
 */
public interface ICommonService {

    List<EquipmentCategory> getEquipmentCategoryList(String code, String type);

    List<LinkedHashMap> getRegion(String level, String parentId);

    List<LinkedHashMap> getTree(ReginParams selectedOrgInfo);

    List<LinkedHashMap> getApproveTree(ReginParams reginParams);

    List<LinkedHashMap> creatTree();

    List<Map<String, Object>> getUnitListByType(String type, String business, Boolean needAuth);

    /**
     * 查询所有检验检测信息
     *
     * @param type 类型
     * @return list
     */
    List<Map<String, Object>> getAllInspectionInfo(String type);

    List<Map<String, Object>> getSecurityAdmin(String type, String useUnitCode);

    Map<String, Object> getUserInfo(String sequenceNbr);

    Map<String, Object> getEnterpriseInfo(String useCode);

    List<Map<String, Object>> getEnterpriseEmployee(String unitCode);

    void generateCertificateReport(Map<String, Object> map, HttpServletResponse response);

    void generateCertificateReportDoc(Map<String, Object> map, HttpServletResponse response);

    void generatePdfPrint(Map<String, Object> map, HttpServletResponse response);

    byte[] generateSummaryOfCylinderInfo(Map<String, Object> map, String wordPath, String filePrefix);

    List<LinkedHashMap> creatApproveTree();

    List<Map<String, Object>> superviseBusinessCategory(String businessType, String dataSource);

    List<Map<String, Object>> businessScenarios(String type);

    Object invokeBusinessProcess(String submitType, Map<String, Object> obj, ReginParams reginParams);

    Object invokeBusinessType(Map<String, Object> obj);

    Object updateHistory(Map<String, Object> obj);

    Object getCompanyUser(Long companyId);

    Object transfer(Map<String, Object> obj);

    List<LinkedHashMap> getCreatTree();

    List<LinkedHashMap> loginUnitAndBelowGetTree(String orgCode);

    List<LinkedHashMap> getCreatTreeByInstallation();

    List<LinkedHashMap> getCreatTreeByInstallationTree();

    /**
     * 接收机构树
     *
     * @param bizType 业务类型： notice-告知类， register-登记类
     * @return List<Map>
     */
    List<LinkedHashMap> getReceiveUnitTree(String bizType);

    Boolean checkUniquenessOfEQUCODE(String equCode);


    Map<String, Object> getPermissionTreeWithCompany(String menuAgent, String permissionType, String path, CompanyBo company);

    /**
     * 使用标志生成
     *
     * @param useFlagParamDto 参数
     * @param response        文件信息
     */
    void useFlagGenerate(UseFlagParamDto useFlagParamDto, HttpServletResponse response);

    Map<String, Object> getUserPhone(String name);


    List<Map<String, String>> equOnJgServiceOperationRecords(String record);

    /**
     * 执行流程时前置校验
     *
     * @param taskId     任务id
     * @param instanceId 实例id
     */
    void checkForExecuteFlow(String taskId, String instanceId);


    /**
     * 最新流程数据缓存
     *
     * @param instanceId   实例id
     * @param instanceData 流程数据
     */
    void saveExecuteFlowData2Redis(String instanceId, InstanceRuntimeData instanceData);

    /**
     * 撤回时校验
     *
     * @param taskId     前端业务上送任务id
     * @param instanceId 实例id
     */
    void checkForRevocationFlow(String taskId, String instanceId);


    /**
     * 创建或者更新历史表
     *
     * @param registrationClass 分类
     * @param map               过程数据
     * @param equipId           设备唯一标识
     * @param currentDocumentId 业务id
     */
    void saveOrUpdateHistory(String registrationClass, JSON map, String equipId, String currentDocumentId);


    /**
     * 查询历史数据
     *
     * @param currentDocumentId 业务id
     * @return JSONObject
     */
    JSONObject queryHistoryData(Long currentDocumentId);

    /**
     * 查询历史数据: 通用
     *
     * @param currentDocumentId 业务id
     * @return Object
     */
    JSONArray queryHistoryDataObj(Long currentDocumentId);

    /**
     * 统计指定设备流程中的引用次数（12个流程中，非待提交、非已撤回、非已驳回）
     *
     * @param record 设备唯一标识
     * @return 被引用次数 > 0 则设备不可编辑
     */
    Integer countEquipInUseTimesForEdit(String record);


    /**
     * 统计设备是否被引用（只有存在就算引用，作废及删除的单据除外）
     *
     * @param record 设备唯一标识
     * @return 被引用次数
     */
    Boolean checkEquipIsUsed(String record);

    /**
     * 设备分类
     *
     * @param type 1，设备种类  2，设备类别  3，设备品种
     * @return
     */
    List<EquipmentCategoryDto> equipmentClassification(String type);

    List<EquipmentCategoryDto> equipmentPipeType3ByParentCode(String parentCode);

    List<EquipmentCategoryDto> equipmentClassificationByParentCode(String type, String parentCode);

    /**
     * 套打使用标志生成
     *
     * @param useFlagParamDto 参数
     * @param response        文件信息
     */
    void fightUseFlagGenerate(UseFlagParamDto useFlagParamDto, HttpServletResponse response);


    /**
     * 查询since之前已经完成的使用登记单子
     */
    List<String> refreshTheDetailsDataOfCompletedUsageRegistration(String since);

    /**
     * 公司详情
     *
     * @param companyCode 公司编码
     * @return CompanyBo
     */
    CompanyBo getOneCompany(String companyCode);

    Integer checkFactoryNumUniquenessForVehicleCylinder(String factoryNum, String sequenceNbr);

    /**
     * 更新单位类型缓存
     *
     * @param unitType 单位类型
     */
    void updateUnitTypeCache(ReginParams reginParams, String unitType, String selectedRoleSeqs);

    void historicalDataProcessingOfPressurePipeline();

    JgUseRegistrationManage getLatestJgUseRegistrationManage(String useUnitCreditCode, String equCategoryCode);

    /**
     * 检查设备代码的唯一性
     * @param equCode
     * @return
     */
    Boolean checkEquCodeUniqueness(String equCode);

    /**
     * 检查使用登记证号全局唯一
     *
     * @param useRegistrationCode 使用登记证号
     * @param equipId             设备record
     * @return
     */
    Boolean useRegistrationCertificateAccountUnique(String useRegistrationCode, String equipId);

    /**
     * 判断使用登记证编号是否被其他单位使用
     *
     * @param useRegistrationCode
     * @return 占用的使用单位名称
     */
    String isRegistrationNumberUsedByOtherUnits(String useRegistrationCode);

    List<EquipmentCategoryDto> equipmentClassificationNoPipeline(String type);

    List<EquipmentCategoryDto> equipmentClassificationNoPipelineByParentCode(String type, String parentCode);

    List<EquipmentCategoryDto> getEquDefineByParentId(String parentId);

    List<EquipmentClassifyDto> getEquClassifyByCode(String parentCode);

    Map<String, Object> getRegistrationFormUrl(String manageType, JSONObject formData);

    void getRegistrationFormStream(JSONObject formData,String manageType,HttpServletResponse response);

    Map<String, Object> getRegistrationChangeCertificateUrl(JSONObject formData);

    void getRegistrationChangeCertificateFormStream(JSONObject jsonObject, HttpServletResponse response);

    /**
     * 检查record的唯一性
     * @param record
     * @return
     */
    Boolean checkRecordUniqueness(String record);

    JSONArray getPermissionTreeWithCompanyV2(String menuAgent, String permissionType, String path, CompanyBo company, JSONArray params);

    JSONArray allWorkbenchPermission(String businessType, String appCode);
}
