package com.yeejoin.amos.boot.module.ymt.api.dto;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.yeejoin.amos.boot.biz.common.dto.BaseDto;
import lombok.Data;
import lombok.EqualsAndHashCode;
import java.util.Date;

/**
 * 安全追溯-压力容器
 *
 * @author system_generator
 * @date 2023-08-17
 */
@Data
@EqualsAndHashCode(callSuper = true)
@ApiModel(value="IdxBizJgTechParamsVesselDto", description="安全追溯-压力容器")
public class IdxBizJgTechParamsVesselDto  extends BaseDto {

   private static final long serialVersionUID = 1L;




    @TableField("RECORD")
    private String record;



    @TableField("INSTANCE_ID")
    private String instanceId;

    @TableField("STATUS")
    private String status;

    @ApiModelProperty(value = "额定质量")
    @TableField("RATED_QUALITY")
    private String ratedQuality;

    @ApiModelProperty(value = "使用环境温度")
    @TableField("AMBIENT_TEMPERATURE")
    private String ambientTemperature;

    @ApiModelProperty(value = "型号")
    @TableField("MODEL_NUMBER")
    private String modelNumber;

    @ApiModelProperty(value = "数量")
    @TableField("NUM")
    private Integer num;

    @ApiModelProperty(value = "单瓶容积")
    @TableField("SINGLE_BOTTLE_VOLUME")
    private String singleBottleVolume;

    @ApiModelProperty(value = "总容积")
    @TableField("TOTAL_VOLUME")
    private String totalVolume;

    @ApiModelProperty(value = "充装介质")
    @TableField("CHARGING_MEDIUM")
    private String chargingMedium;

    @ApiModelProperty(value = "规格")
    @TableField("SPECIFICATION")
    private String specification;

    @ApiModelProperty(value = "外径")
    @TableField("OUTSIDE_DIAMETER")
    private String outsideDiameter;

    @ApiModelProperty(value = "壁厚")
    @TableField("WALL_THICKNESS")
    private String wallThickness;

    @ApiModelProperty(value = "长度")
    @TableField("LENGTH")
    private String length;

    @ApiModelProperty(value = "公称工作压力")
    @TableField("NOMINAL_WORKING_PRESSURE")
    private String nominalWorkingPressure;

    @ApiModelProperty(value = "材料（瓶体）")
    @TableField("BOTTLE_BODY")
    private String bottleBody;

    @ApiModelProperty(value = "材料（端塞）")
    @TableField("END_PLUG")
    private String endPlug;

    @ApiModelProperty(value = "材料（管路）")
    @TableField("PIPING")
    private String piping;

    @ApiModelProperty(value = "无损检测方法（气瓶）")
    @TableField("QP_LOSSLESS")
    private String qpLossless;

    @ApiModelProperty(value = "无损检测方法（管路）")
    @TableField("GL_LOSSLESS")
    private String glLossless;

    @ApiModelProperty(value = "无损检测比例（气瓶）")
    @TableField("QP_RATIO")
    private String qpRatio;

    @ApiModelProperty(value = "无损检测比例（管路）")
    @TableField("GL_RATIO")
    private String glRatio;

    @ApiModelProperty(value = "耐压试验压力（气瓶）")
    @TableField("QP_PRESSURE")
    private String qpPressure;

    @ApiModelProperty(value = "耐压试验压力（管路）")
    @TableField("GL_PRESSURE")
    private String glPressure;

    @ApiModelProperty(value = "气密性试验压力（气瓶）")
    @TableField("QP_AIR_TIGHTNESS")
    private String qpAirTightness;

    @ApiModelProperty(value = "气密性试验压力（管路）")
    @TableField("GL_AIR_TIGHTNESS")
    private String glAirTightness;

    @ApiModelProperty(value = "气体置换后压力")
    @TableField("DISPLACEMENT_PRESSURE")
    private String displacementPressure;

    @ApiModelProperty(value = "瓶体内含氧量")
    @TableField("OXYGEN")
    private String oxygen;

    @ApiModelProperty(value = "瓶体内含氧量")
    @TableField("HEAT_TREATMENT_METHOD")
    private String heatTreatmentMethod;

    @ApiModelProperty(value = "热处理温度")
    @TableField("QP_HEAT_TREATMENT_TEMPERATURE")
    private String qpHeatTreatmentTemperature;

    @ApiModelProperty(value = "气瓶安装位置")
    @TableField("INSTALLATION_POSITION")
    private String installationPosition;

    @ApiModelProperty(value = "容器容积")
    @TableField("CONTAINER_VOLUME")
    private String containerVolume;

    @ApiModelProperty(value = "容器内径")
    @TableField("PRESSURE_VESSEL_DIAMETER")
    private String pressureVesselDiameter;

    @ApiModelProperty(value = "容器高(长)")
    @TableField("HEIGHT")
    private String height;

    @ApiModelProperty(value = "材料（筒体(球壳)）")
    @TableField("MATERIAL_CYLINDER_SHELL")
    private String materialCylinderShell;

    @ApiModelProperty(value = "材料（封头）")
    @TableField("PRESSURE_MATERIAL_HEAD")
    private String pressureMaterialHead;

    @ApiModelProperty(value = "材料（衬里）")
    @TableField("PRESSURE_MATERIAL_LINING")
    private String pressureMaterialLining;

    @ApiModelProperty(value = "材料（夹套）")
    @TableField("MATERIAL_JACKET")
    private String materialJacket;

    @ApiModelProperty(value = "厚度（筒体(球壳)）")
    @TableField("THICKNESS")
    private String thickness;

    @ApiModelProperty(value = "厚度（封头）")
    @TableField("FIXED_HEAD")
    private String fixedHead;

    @ApiModelProperty(value = "厚度（衬里）")
    @TableField("FIXED_LINING")
    private String fixedLining;

    @ApiModelProperty(value = "厚度（夹套）")
    @TableField("FIXED_JACKET")
    private String fixedJacket;

    @ApiModelProperty(value = "容器自重")
    @TableField("SELF_WEIGHT")
    private String selfWeight;

    @ApiModelProperty(value = "盛装介质重量")
    @TableField("MEDIUM_WEIGHT")
    private String mediumWeight;

    @ApiModelProperty(value = "设计压力（壳程）")
    @TableField("PRESSURE_HOUSING_PATH")
    private String pressureHousingPath;

    @ApiModelProperty(value = "设计压力（管程）")
    @TableField("PRESSURE_PIPE")
    private String pressurePipe;

    @ApiModelProperty(value = "设计压力（夹套）")
    @TableField("PRESSURE_JACKET")
    private String pressureJacket;

    @ApiModelProperty(value = "设计温度（壳程）")
    @TableField("TEMPERATURE_SHELL")
    private String temperatureShell;

    @ApiModelProperty(value = "设计温度（管程）")
    @TableField("TEMPERATURE_PIPE")
    private String temperaturePipe;

    @ApiModelProperty(value = "设计温度（夹套）")
    @TableField("TEMPERATURE_JACKET")
    private String temperatureJacket;

    @ApiModelProperty(value = "最高允许工作压力（壳程）")
    @TableField("MAX_PRESSURE_SHELL")
    private String maxPressureShell;

    @ApiModelProperty(value = "最高允许工作压力（管程）")
    @TableField("MAX_PRESSURE_PIPE")
    private String maxPressurePipe;

    @ApiModelProperty(value = "最高允许工作压力（夹套）")
    @TableField("MAX_PRESSURE_JACKET")
    private String maxPressureJacket;

    @ApiModelProperty(value = "介质（壳程）")
    @TableField("MEDIUM_SHELL")
    private String mediumShell;

    @ApiModelProperty(value = "介质（管程）")
    @TableField("MEDIUM_PIPE")
    private String mediumPipe;

    @ApiModelProperty(value = "介质（夹套）")
    @TableField("MEDIUM_JACKET")
    private String mediumJacket;

    @ApiModelProperty(value = "主体结构型式")
    @TableField("MAIN_STRUCTURE_TYPE")
    private String mainStructureType;

    @ApiModelProperty(value = "支座型式")
    @TableField("SUPPORT")
    private String support;

    @ApiModelProperty(value = "安装型式")
    @TableField("INSTALLATION")
    private String installation;

    @ApiModelProperty(value = "保温绝热方式")
    @TableField("INSULATION")
    private String insulation;

    @ApiModelProperty(value = "无损检测方法")
    @TableField("CHECK_LOSSLESS")
    private String checkLossless;

    @ApiModelProperty(value = "耐压试验种类")
    @TableField("WITHSTAND_VOLTAGE")
    private String withstandVoltage;

    @ApiModelProperty(value = "泄漏试验种类")
    @TableField("LEAKAGE")
    private String leakage;

    @ApiModelProperty(value = "耐压试验压力")
    @TableField("WITHSTAND_PRESSURE_TEST")
    private String withstandPressureTest;

    @ApiModelProperty(value = "泄漏试验压力")
    @TableField("LEAK_PRESSURE")
    private String leakPressure;

    @ApiModelProperty(value = "容器型号")
    @TableField("CONTAINER")
    private String container;

    @ApiModelProperty(value = "罐车编号")
    @TableField("CAR_NUM")
    private String carNum;

    @ApiModelProperty(value = "容积")
    @TableField("VOLUME")
    private String volume;

    @ApiModelProperty(value = "最大充装量")
    @TableField("MAX_FILL")
    private String maxFill;

    @ApiModelProperty(value = "设计压力")
    @TableField("DESIGN_PRESSURE")
    private String designPressure;

    @ApiModelProperty(value = "设计温度")
    @TableField("DESIGN_TEMPERATURE")
    private String designTemperature;

    @ApiModelProperty(value = "工作压力")
    @TableField("WORKING_PRESSURE")
    private String workingPressure;

    @ApiModelProperty(value = "工作温度")
    @TableField("WORK_TEMPERATURE")
    private String workTemperature;

    @ApiModelProperty(value = "材料（筒体）")
    @TableField("MATERIAL_CYLINDER")
    private String materialCylinder;

    @ApiModelProperty(value = "厚度（筒体）")
    @TableField("THICKNESS_CYLINDER")
    private String thicknessCylinder;

    @ApiModelProperty(value = "腐蚀裕量")
    @TableField("CORROSION_MARGIN")
    private String corrosionMargin;

    @ApiModelProperty(value = "介质")
    @TableField("MEDIUM")
    private String medium;

    @ApiModelProperty(value = "氧舱品种")
    @TableField("OXYGEN_CHAMBER")
    private String oxygenChamber;

    @ApiModelProperty(value = "额定进舱人数")
    @TableField("RATED_ENTRY_CAPACITY")
    private Integer ratedEntryCapacity;

    @ApiModelProperty(value = "主体结构")
    @TableField("CHAMBER_MAIN")
    private String chamberMain;

    @ApiModelProperty(value = "压力")
    @TableField("CHAMBER_PRESSURE")
    private String chamberPressure;

    @ApiModelProperty(value = "温度")
    @TableField("TEMPERATURE")
    private String temperature;

    @ApiModelProperty(value = "压力介质")
    @TableField("PRESSURE_MEDIUM")
    private String pressureMedium;

    @ApiModelProperty(value = "人均舱容")
    @TableField("PER_CAPITA_CABIN_CAPACITY")
    private String perCapitaCabinCapacity;

}
