package com.yeejoin.amos.api.openapi.face.model;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import lombok.Data;
import lombok.EqualsAndHashCode;
import java.util.Date;
import com.yeejoin.amos.api.openapi.face.model.AbstractBaseModel;
/**
 * 安全追溯-制造信息
 *
 * @author cpp
 * @date 2023-04-06 15:21:22
 */
@Data
@EqualsAndHashCode(callSuper = true)
@ApiModel(value="MidEquipFactoryInfoDto", description="安全追溯-制造信息Dto")
public class ProduceInfoModel extends AbstractBaseModel {
    private static final long serialVersionUID = 1L;


    @ApiModelProperty(value = "$column.comments")
    private String supervisoryCode;

    private String instanceId;
    @ApiModelProperty(value = "$column.comments")
    private String status;
    @ApiModelProperty(value = "制造单位统一社会信用代码")
    private String produceUnitCreditCode;
    @ApiModelProperty(value = "制造单位名称")
    private String produceUnitName;
    @ApiModelProperty(value = "制造许可编号")
    private String produceLicenseNum;
    @ApiModelProperty(value = "出厂编号")
    private String factoryNum;
    @ApiModelProperty(value = "制造日期")
    private Date produceDate;
    @ApiModelProperty(value = "是否进口")
    private String imported;
    @ApiModelProperty(value = "制造国")
    private String produceCountry;
    @ApiModelProperty(value = "制造标准")
    private String factoryStandard;
    @ApiModelProperty(value = "产品质量合格证明")
    private String productQualityYieldProve;
    @ApiModelProperty(value = "安装及使用维护保养说明")
    private String insUseMaintainExplain;
    @ApiModelProperty(value = "监督检验证书")
    private String supervisionAgencyCredential;
    @ApiModelProperty(value = "型式试验证书")
    private String typeTestCredential;


}
