package com.yeejoin.amos.boot.module.elevator.api.entity;

import java.util.Date;

import org.typroject.tyboot.core.rdbms.orm.entity.BaseEntity;

import com.baomidou.mybatisplus.annotation.TableName;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.experimental.Accessors;

/**
 * 特种设备基本信息-施工信息
 *
 * @author duanwei
 * @date 2022-07-26
 */
@Data
@Accessors(chain = true)
@TableName("tz_jg_construction_info")
@ApiModel(value = "TzsJgConstructionInfo对象", description = "特种设备基本信息-施工信息")
public class TzsJgConstructionInfo extends BaseEntity {

	private static final long serialVersionUID = 1L;

	@ApiModelProperty(value = "设备唯一标识码")
	private String sequenceCode;

	@ApiModelProperty(value = "监管系统唯一编码")
	private String superviseCode;

	@ApiModelProperty(value = "施工类型(安装、改造、移装)")
	private String constructionType;

	@ApiModelProperty(value = "施工单位统一社会信用代码")
	private String uscUnitCreditCode;

	@ApiModelProperty(value = "施工单位名称")
	private String uscUnitName;

	@ApiModelProperty(value = "安装/改造/移装告知ID")
	private String uscInformId;

	@ApiModelProperty(value = "施工时间")
	private Date uscDate;

	@ApiModelProperty(value = "同步时间")
	private Date syncDate;

	@ApiModelProperty(value = "同步状态（0-新增   1-更新   2-删除）")
	private Integer syncState;

	@ApiModelProperty(value = "对接公司编码")
	private String appId;

}
