package com.yeejoin.amos.boot.module.common.api.dto;


import java.util.List;

import com.yeejoin.amos.boot.biz.common.dto.BaseDto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * 维保单位
 *
 * @author system_generator
 * @date 2021-07-16
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@ApiModel(value = "MaintenancePersonDto", description = "维保单位人员")
public class MaintenancePersonDto extends BaseDto {
	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;
	
	@ApiModelProperty(value = "员工姓名")	
    private String name;
	
	@ApiModelProperty(value = "注册号")
	private String amosAccount;
	
	@ApiModelProperty(value = "类型（COMPANY单位，PERSON人员，DEPARTMENT部门）")
	private String type;
	@ApiModelProperty(value = "类别")	
	private String category;
	@ApiModelProperty(value = "证书编号")
	private String certificateNo;
	@ApiModelProperty(value = "性别")	
	private String gender;
	@ApiModelProperty(value = "身份证号码")
	private String	idNumber;
	@ApiModelProperty(value = "民族")	
	private String nation;
	//消防重点工种资格证书
	@ApiModelProperty(value = "职业资格证书")	
	private String professionalCertificate;
	//人员资质
	@ApiModelProperty(value = "职业资格")	
	private String qualification;
	@ApiModelProperty(value = "注册号")	
	private String registerId;
	@ApiModelProperty(value = "状态")	
	private String status;
	@ApiModelProperty(value = "手机号码")	
	private String tel;
	@ApiModelProperty(value = "部门编号")	
	private String departmentNumber;
	
	@ApiModelProperty(value = "系统账户")	
	private String systemAccount;
	
	@ApiModelProperty(value = "注册有效期开始时间")	
	private String registrationStartTime;
	
	@ApiModelProperty(value = "注册有效期结束时间")	
	private String registrationEndTime;
	
	@ApiModelProperty(value = "员工编号")	
	private String code;
	
	
	@ApiModelProperty(value = "员工所在单位单位id")	
    private Long parentId;
	@ApiModelProperty(value = "上传资源的地址集合")	
	private List<String> resourcesAdress;
	
	
}
