package com.yeejoin.amos.boot.module.jczs.api.mapper;

import com.yeejoin.amos.boot.module.jczs.api.dto.ElevatorListDto;
import com.yeejoin.amos.boot.module.jczs.api.entity.ElevatorRelation;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * 关注电梯关系表 Mapper 接口
 *
 * @author system_generator
 * @date 2021-10-08
 */
public interface ElevatorRelationMapper extends BaseMapper<ElevatorRelation> {

    /**
     * 获取是否关注电梯
     * @param openId
     * @param elevatorId
     * @return
     */
    Integer hasFocusElevator(@Param("openId") String openId, @Param("elevatorId") Long elevatorId);

    /**
     * 关注电梯
     * @param openId
     * @param elevatorId
     * @return
     */
    Integer focusElevator(@Param("openId") String openId, @Param("elevatorId") String elevatorId);

    /**
     * 取消关注电梯
     * @param openId
     * @param elevatorId
     * @return
     */
    Integer cancelFocusElevator(@Param("openId") String openId, @Param("elevatorId") String elevatorId);

    /**
     * 获取用户关注电梯列表
     * @param openId
     * @return
     */
    List<ElevatorListDto> getMyFocusElevator(@Param("openId") String openId);

}
