package com.yeejoin.amos.boot.module.jg.biz.controller;

import org.springframework.web.bind.annotation.RequestMapping;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.Api;
import org.springframework.web.bind.annotation.RestController;
import com.yeejoin.amos.boot.biz.common.controller.BaseController;
import java.util.List;
import com.yeejoin.amos.boot.module.jg.biz.service.impl.JgOperateLogServiceImpl;
import org.typroject.tyboot.core.restful.utils.ResponseHelper;
import org.typroject.tyboot.core.restful.utils.ResponseModel;
import org.springframework.beans.factory.annotation.Autowired;
import javax.servlet.http.HttpServletRequest;
import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yeejoin.amos.boot.module.jg.api.dto.JgOperateLogDto;
import org.typroject.tyboot.core.restful.doc.TycloudOperation;
import org.typroject.tyboot.core.foundation.enumeration.UserType;

/**
 * 监管业务操作日志表
 *
 * @author system_generator
 * @date 2023-12-12
 */
@RestController
@Api(tags = "监管业务操作日志表Api")
@RequestMapping(value = "/jg-operate-log")
public class JgOperateLogController extends BaseController {

    @Autowired
    JgOperateLogServiceImpl jgOperateLogServiceImpl;

    /**
     * 新增
     *
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
	@PostMapping(value = "/save")
	@ApiOperation(httpMethod = "POST", value = "新增监管业务操作日志表", notes = "新增监管业务操作日志表")
	public ResponseModel<JgOperateLogDto> save(@RequestBody JgOperateLogDto model) {
	    model = jgOperateLogServiceImpl.createWithModel(model);
	    return ResponseHelper.buildResponse(model);
	}

	/**
     * 根据sequenceNbr更新
     *
     * @param sequenceNbr 主键
     * @return
     */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@PutMapping(value = "/{sequenceNbr}")
	@ApiOperation(httpMethod = "PUT", value = "根据sequenceNbr更新监管业务操作日志表", notes = "根据sequenceNbr更新监管业务操作日志表")
	public ResponseModel<JgOperateLogDto> updateBySequenceNbrJgOperateLog(@RequestBody JgOperateLogDto model,@PathVariable(value = "sequenceNbr") Long sequenceNbr) {
	    model.setSequenceNbr(sequenceNbr);
	    return ResponseHelper.buildResponse(jgOperateLogServiceImpl.updateWithModel(model));
	}

	/**
     * 根据sequenceNbr删除
     *
     * @param sequenceNbr 主键
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @DeleteMapping(value = "/{sequenceNbr}")
    @ApiOperation(httpMethod = "DELETE", value = "根据sequenceNbr删除监管业务操作日志表", notes = "根据sequenceNbr删除监管业务操作日志表")
    public ResponseModel<Boolean> deleteBySequenceNbr(HttpServletRequest request, @PathVariable(value = "sequenceNbr") Long sequenceNbr){
        return ResponseHelper.buildResponse(jgOperateLogServiceImpl.removeById(sequenceNbr));
    }

    /**
     * 根据sequenceNbr查询
     *
	 * @param sequenceNbr  主键
     * @return
     */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@GetMapping(value = "/{sequenceNbr}")
	@ApiOperation(httpMethod = "GET",value = "根据sequenceNbr查询单个监管业务操作日志表",  notes = "根据sequenceNbr查询单个监管业务操作日志表")
	public ResponseModel<JgOperateLogDto> selectOne(@PathVariable Long sequenceNbr) {
	    return ResponseHelper.buildResponse(jgOperateLogServiceImpl.queryBySeq(sequenceNbr));
	}

	/**
     * 列表分页查询
     *
     * @param current 当前页
     * @param current 每页大小
     * @return
     */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@GetMapping(value = "/page")
	@ApiOperation(httpMethod = "GET",value = "监管业务操作日志表分页查询",  notes = "监管业务操作日志表分页查询")
	public ResponseModel<Page<JgOperateLogDto>> queryForPage(@RequestParam(value = "current") int current,@RequestParam
                    (value = "size") int size) {
	    Page<JgOperateLogDto> page = new Page<JgOperateLogDto>();
	    page.setCurrent(current);
	    page.setSize(size);
	    return ResponseHelper.buildResponse(jgOperateLogServiceImpl.queryForJgOperateLogPage(page));
	}

	/**
	 * 列表全部数据查询
     *
	 * @return
	 */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@ApiOperation(httpMethod = "GET",value = "监管业务操作日志表列表全部数据查询",   notes = "监管业务操作日志表列表全部数据查询")
	@GetMapping(value = "/list")
	public ResponseModel<List<JgOperateLogDto>> selectForList() {
	    return ResponseHelper.buildResponse(jgOperateLogServiceImpl.queryForJgOperateLogList());
	}
}
