package com.yeejoin.amos.boot.module.statistcs.biz.service.impl;

import com.yeejoin.amos.boot.module.statistics.api.mapper.DPSubBizMapper;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;
import org.typroject.tyboot.core.foundation.utils.DateTimeUtil;
import org.typroject.tyboot.core.foundation.utils.DateUtil;

import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * 大屏二级页面实现类
 *
 * @author Administrator
 */
@Slf4j
@Service
public class DPSubBizServiceImpl {

    private DPSubBizMapper dpSubBizMapper;

    public DPSubBizServiceImpl(DPSubBizMapper dpSubBizMapper) {
        this.dpSubBizMapper = dpSubBizMapper;
    }

    /**
     * 查询设备在jg业务中的记录
     *
     * @param record
     * @return
     */
    public List<Map<String, String>> equOnJgServiceOperationRecords(String record) {
        return dpSubBizMapper.equOnJgServiceOperationRecords(record).stream()
                .map(x -> {
                    Map<String, String> map = new HashMap<>();
                    map.put("operatingTime", x.get("recDate"));
                    String content = String.format("%s  创建人：%s  单号【%s】  审批单位：%s",
                            x.get("businessType"), x.get("recUserName"), x.get("applyNo"), x.get("approvalUnit"));
                    map.put("operater", content);
                    map.put("routePath", x.get("routePath"));
                    return map;
                })
                .collect(Collectors.toList());
    }

    /**
     * 问题记录列表
     * @param sourceId
     * @return
     */
    public List<Map<String, String>> queryProblemListBySourceId(String sourceId) {
        return dpSubBizMapper.queryForSafetyProblemTracingList(sourceId).stream()
                .map(x -> {
                    Map<String, String> map = new HashMap<>();
                    map.put("key", x.get("sequence_nbr"));
                    map.put("type", x.get("problem_type"));
                    map.put("descr", x.get("problem_desc"));
                    map.put("createDate", x.get("problemTime"));
                    return map;
                })
                .collect(Collectors.toList());
    }
}
